//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_VoiceInfo.h"
#include "jni_utils.h"
#include "speechapi_c_result.h"
#include "speechapi_c_property_bag.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getName
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getName
  (JNIEnv *env, jobject , jobject voiceInfoHandle)
{
    jstring result;
    jlong voiceHandle = GetObjectHandle(env, voiceInfoHandle);
    const char* str = voice_info_get_name((SPXRESULTHANDLE)voiceHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getLocale
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getLocale
  (JNIEnv *env, jobject, jobject voiceInfoHandle)
{
    jstring result;
    jlong voiceHandle = GetObjectHandle(env, voiceInfoHandle);
    const char* str = voice_info_get_locale((SPXRESULTHANDLE)voiceHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getShortName
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getShortName
  (JNIEnv *env, jobject, jobject voiceInfoHandle)
{
    jstring result;
    jlong voiceHandle = GetObjectHandle(env, voiceInfoHandle);
    const char* str = voice_info_get_short_name((SPXRESULTHANDLE)voiceHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getLocalName
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getLocalName
  (JNIEnv *env, jobject, jobject voiceInfoHandle)
{
    jstring result;
    jlong voiceHandle = GetObjectHandle(env, voiceInfoHandle);
    const char* str = voice_info_get_local_name((SPXRESULTHANDLE)voiceHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getStyleListString
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getStyleListString
  (JNIEnv *env, jobject, jobject voiceInfoHandle)
{
    jstring result;
    jlong voiceHandle = GetObjectHandle(env, voiceInfoHandle);
    const char* str = voice_info_get_style_list((SPXRESULTHANDLE)voiceHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getVoicePath
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getVoicePath
  (JNIEnv *env, jobject, jobject voiceInfoHandle)
{
    jstring result;
    jlong voiceHandle = GetObjectHandle(env, voiceInfoHandle);
    const char* str = voice_info_get_voice_path((SPXRESULTHANDLE)voiceHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getVoiceType
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getVoiceType
  (JNIEnv *env, jobject , jobject voiceInfoHandle, jobject voiceTypeRef)
{
    Synthesis_VoiceType voiceType;
    jlong handle = GetObjectHandle(env, voiceInfoHandle);
    SPXHR hr = voice_info_get_voice_type((SPXRESULTHANDLE)handle, &voiceType);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, voiceTypeRef, (jlong)voiceType);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_VoiceInfo
 * Method:    getPropertyBagFromResult
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_VoiceInfo_getPropertyBagFromResult
  (JNIEnv *env, jobject , jobject voiceInfoHandle, jobject propertyHandle)
{
    SPXPROPERTYBAGHANDLE progbag = SPXHANDLE_INVALID;
    jlong handle = GetObjectHandle(env, voiceInfoHandle);
    SPXHR hr = voice_info_get_property_bag((SPXRESULTHANDLE)handle, &progbag);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, propertyHandle, (jlong)progbag);
    }
    return (jlong)hr;
}
