//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_SynthesisVoicesResult.h"
#include "jni_utils.h"
#include "speechapi_c_synthesizer.h"
#include "speechapi_c_result.h"

const size_t maxCharCount = 1024;

/*
 * Class:     com_microsoft_cognitiveservices_speech_SynthesisVoicesResult
 * Method:    getResultId
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SynthesisVoicesResult_getResultId
  (JNIEnv *env, jobject , jobject resultHandle, jobject resultIdRef)
{
    char sz[maxCharCount + 1] = {};
    jlong handle = GetObjectHandle(env, resultHandle);
    SPXHR hr = synthesis_voices_result_get_result_id((SPXRESULTHANDLE)handle, sz, maxCharCount);
    if (SPX_SUCCEEDED(hr))
    {
        hr = SetStringObjectHandle(env, resultIdRef, sz);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SynthesisVoicesResult
 * Method:    getResultReason
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SynthesisVoicesResult_getResultReason
  (JNIEnv *env, jobject , jobject resultHandle, jobject reasonRef)
{
    Result_Reason resultReason;
    jlong handle = GetObjectHandle(env, resultHandle);
    SPXHR hr = synthesis_voices_result_get_reason((SPXRESULTHANDLE)handle, &resultReason);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, reasonRef, (jlong)resultReason);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SynthesisVoicesResult
 * Method:    getPropertyBagFromResult
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SynthesisVoicesResult_getPropertyBagFromResult
  (JNIEnv *env, jobject , jobject resultHandle, jobject propertyHandle)
{
    SPXPROPERTYBAGHANDLE progbag = SPXHANDLE_INVALID;
    jlong handle = GetObjectHandle(env, resultHandle);
    SPXHR hr = synthesis_voices_result_get_property_bag((SPXRESULTHANDLE)handle, &progbag);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, propertyHandle, (jlong)progbag);
    }
    return (jlong)hr;
}
/*
 * Class:     com_microsoft_cognitiveservices_speech_SynthesisVoicesResult
 * Method:    getVoiceNumber
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SynthesisVoicesResult_getVoiceNumber
  (JNIEnv *env, jobject , jobject resultHandle, jobject voiceNumberRef)
{
    uint32_t voiceNumber = 0;
    jlong handle = GetObjectHandle(env, resultHandle);
    SPXHR hr = synthesis_voices_result_get_voice_num((SPXRESULTHANDLE)handle, &voiceNumber);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, voiceNumberRef, (jlong)voiceNumber);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SynthesisVoicesResult
 * Method:    getVoiceInfo
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;ILcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SynthesisVoicesResult_getVoiceInfo
  (JNIEnv *env, jobject , jobject resultHandle, jint index, jobject voiceInfoRef)
{
    jlong handle = GetObjectHandle(env, resultHandle);
    SPXRESULTHANDLE voiceInfo = SPXHANDLE_INVALID;
    SPXHR hr = synthesis_voices_result_get_voice_info((SPXRESULTHANDLE)handle, (uint32_t)index, &voiceInfo);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, voiceInfoRef, (jlong)voiceInfo);
    }
    return (jlong)hr;
}
