//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_SpeechSynthesisWordBoundaryEventArgs.h"
#include "jni_utils.h"
#include "speechapi_c_synthesizer.h"
#include "speechapi_c_property_bag.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechSynthesisWordBoundaryEventArgs
 * Method:    getWordBoundaryEventValues
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechSynthesisWordBoundaryEventArgs_getWordBoundaryEventValues
  (JNIEnv *env, jobject , jobject eventHandle, jobject audioOffsetRef, jobject durationRef, jobject textOffsetRef, jobject wordLengthRef, jobject boundaryTypeRef)
{
    jlong event = GetObjectHandle(env, eventHandle);
    uint64_t audioOffset = 0;
    uint64_t duration = 0;
    uint32_t textOffset = 0;
    uint32_t wordLength = 0;
    SpeechSynthesis_BoundaryType boundaryType = SpeechSynthesis_BoundaryType_Word;
    SPXHR hr = synthesizer_word_boundary_event_get_values((SPXEVENTHANDLE)event, &audioOffset, &duration, &textOffset, &wordLength, &boundaryType);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioOffsetRef, (jlong)audioOffset);
        SetObjectHandle(env, durationRef, (jlong)duration);
        SetObjectHandle(env, textOffsetRef, (jlong)textOffset);
        SetObjectHandle(env, wordLengthRef, (jlong)wordLength);
        SetObjectHandle(env, boundaryTypeRef, (jlong)boundaryType);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechSynthesisWordBoundaryEventArgs
 * Method:    getTextFromHandle
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechSynthesisWordBoundaryEventArgs_getTextFromHandle
  (JNIEnv *env, jobject, jobject eventHandle, jobject textStrRef)
{
    jlong event = GetObjectHandle(env, eventHandle);
    const char* str = synthesizer_event_get_text((SPXEVENTHANDLE)event);
    SPXHR hr = SPXERR_RUNTIME_ERROR;
    if (str != nullptr)
    {
        hr = SetStringObjectHandle(env, textStrRef, str);
        property_bag_free_string(str);
    }
    return hr;
}