//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_SpeechRecognitionModel.h"
#include "speechapi_c_speech_recognition_model.h"
#include "speechapi_c_property_bag.h"
#include "jni_utils.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechRecognitionModel
 * Method:    getName
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechRecognitionModel_getName
  (JNIEnv *env, jobject , jobject modelInfoHandle)
{
    jstring result;
    jlong modelHandle = GetObjectHandle(env, modelInfoHandle);
    const char* str = speech_recognition_model_get_name((SPXSPEECHRECOMODELHANDLE)modelHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechRecognitionModel
 * Method:    getLocalesString
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechRecognitionModel_getLocalesString
  (JNIEnv *env, jobject, jobject modelInfoHandle)
{
    jstring result;
    jlong modelHandle = GetObjectHandle(env, modelInfoHandle);
    const char* str = speech_recognition_model_get_locales((SPXSPEECHRECOMODELHANDLE)modelHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechRecognitionModel
 * Method:    getPath
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechRecognitionModel_getPath
  (JNIEnv *env, jobject, jobject modelInfoHandle)
{
    jstring result;
    jlong modelHandle = GetObjectHandle(env, modelInfoHandle);
    const char* str = speech_recognition_model_get_path((SPXSPEECHRECOMODELHANDLE)modelHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechRecognitionModel
 * Method:    getVersion
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechRecognitionModel_getVersion
  (JNIEnv *env, jobject, jobject modelInfoHandle)
{
    jstring result;
    jlong modelHandle = GetObjectHandle(env, modelInfoHandle);
    const char* str = speech_recognition_model_get_version((SPXSPEECHRECOMODELHANDLE)modelHandle);
    result = str ? env->NewStringUTF(str) : env->NewStringUTF("");
    if (str != nullptr)
    {
        property_bag_free_string(str);
    }
    return result;
}
