//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.speaker;

/**
 * Defines voice profile types.
 */
public enum VoiceProfileType {
    /**
     * Text independent speaker identification.
     */
    TextIndependentIdentification(1),
    /**
     * Text dependent speaker verification.
     */
    TextDependentVerification(2),
    /**
     * Text independent speaker verification.
     */
    TextIndependentVerification(3);

    private VoiceProfileType(int id) {
        this.id = id;
    }

    /**
     * Returns the internal value of voice profile type
     *
     * @return the voice profile type value
     */
    public int getValue() { return this.id; }

    private final int id;
}
