//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.audio;

/**
 * Types of preset microphone array geometries.
 * Check https://docs.microsoft.com/azure/cognitive-services/speech-service/speech-devices-sdk-microphone for details.
 */
public enum PresetMicrophoneArrayGeometry {
    /**
     * Indicates that no geometry specified. Speech SDK will determine the microphone array geometry.
     */
    Uninitialized,

    /**
     * Indicates a microphone array with one microphone in the center and six microphones evenly spaced
     * in a circle with radius approximately equal to 42.5 mm.
     */
    Circular7,

    /**
     * Indicates a microphone array with one microphone in the center and three microphones evenly spaced
     * in a circle with radius approximately equal to 42.5 mm.
     */
    Circular4,

    /**
     * Indicates a microphone array with four linearly placed microphones with 40 mm spacing between them.
     */
    Linear4,

    /**
     * Indicates a microphone array with two linearly placed microphones with 40 mm spacing between them.
     */
    Linear2,

    /**
     * Indicates a microphone array with a single microphone.
     */
    Mono,

    /**
     * Indicates a microphone array with custom geometry.
     */
    Custom
}
