//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.audio;

/**
 * Represents coordinates of a microphone.
 *
 */
public class MicrophoneCoordinates {

    /**
     * X-coordinate of the microphone.
     */
    private int X;
    
    /**
     * Y-coordinate of the microphone.
     */
    private int Y;
    
    /**
     * Z-coordinate of the microphone.
     */
    private int Z;

    /**
     * Creates a new object of MicrophoneCoordinates.
     * @param X Specifies the X-coordinate of the microphone, in millimeters.
     * @param Y Specifies the Y-coordinate of the microphone, in millimeters.
     * @param Z Specifies the Z-coordinate of the microphone, in millimeters.
     */
    public MicrophoneCoordinates(int X, int Y, int Z) {
        this.X = X;
        this.Y = Y;
        this.Z = Z;
    }

    /**
     * Creates a new object of MicrophoneCoordinates using object instance.
     * @param other A MicrophoneCoordinates object.
     */
    public MicrophoneCoordinates(MicrophoneCoordinates other) {
        X = other.X;
        Y = other.Y;
        Z = other.Z;
    }

    /**
     * Returns the X-coordinate of the microphone.
     * @return X-coordinate.
     */
    public int getX() {
        return X;
    }

    /**
     * Returns the Y-coordinate of the microphone.
     * @return Y-coordinate.
     */
    public int getY() {
        return Y;
    }

    /**
     * Returns the Z-coordinate of the microphone.
     * @return Z-coordinate.
     */
    public int getZ() {
        return Z;
    }

}
