/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.msg;

import com.jfinal.log.Log;
import com.jfinal.weixin.sdk.utils.XmlHelper;
import com.jfinal.wxaapp.msg.IMsgParser;
import com.jfinal.wxaapp.msg.MsgModel;
import com.jfinal.wxaapp.msg.MsgModelParser;
import com.jfinal.wxaapp.msg.XPath;
import com.jfinal.wxaapp.msg.bean.WxaMsg;
import java.lang.reflect.Field;

public class XmlMsgParser
extends MsgModelParser
implements IMsgParser {
    private static Log log = Log.getLog(XmlMsgParser.class);

    @Override
    public WxaMsg parser(String msgStr) {
        XmlHelper xmlHelper = XmlHelper.of(msgStr);
        MsgModel msgModel = XmlMsgParser.toMsgModel(xmlHelper);
        return this.parserMsg(msgModel);
    }

    private static MsgModel toMsgModel(XmlHelper xmlHelper) {
        Field[] fields;
        MsgModel msgModel = new MsgModel();
        for (Field field : fields = MsgModel.class.getDeclaredFields()) {
            XPath xpathAnno = field.getAnnotation(XPath.class);
            if (xpathAnno == null) continue;
            String xpath = xpathAnno.value();
            Class<?> type = field.getType();
            String strValue = xmlHelper.getString(xpath);
            Object value = XmlMsgParser.convert(type, strValue);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(msgModel, value);
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return msgModel;
    }

    private static final Object convert(Class<?> type, String s) {
        if (type == String.class) {
            return "".equals(s) ? null : s;
        }
        if ("".equals(s = s.trim())) {
            return null;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.parseInt(s);
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.parseLong(s);
        }
        throw new RuntimeException("Please add code in " + XmlMsgParser.class + ". The type can't be converted: " + type.getName());
    }
}

