/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow.handler;

import com.jfinal.server.undertow.UndertowConfig;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;

public class HttpToHttpsHandler
implements HttpHandler {
    protected HttpHandler next;
    protected String httpsPrefix;
    protected int statusCode;
    protected UndertowConfig config;

    public HttpToHttpsHandler(HttpHandler next, UndertowConfig undertowConfig) {
        this.next = next;
        this.config = undertowConfig;
        this.statusCode = undertowConfig.getHttpToHttpsStatusCode();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String scheme = exchange.getRequestScheme();
        if ("http".equals(scheme)) {
            String httpsUrl = this.buildRedirectHttpsUrl(exchange);
            exchange.setStatusCode(this.statusCode);
            exchange.getResponseHeaders().put(Headers.LOCATION, httpsUrl);
            exchange.getResponseHeaders().put(Headers.CONNECTION, "close");
            exchange.endExchange();
        } else {
            this.next.handleRequest(exchange);
        }
    }

    protected String buildRedirectHttpsUrl(HttpServerExchange exchange) {
        if (this.httpsPrefix == null) {
            this.buildUrlPrefix(exchange);
        }
        String uri = exchange.getRequestURI();
        String queryString = exchange.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            StringBuilder ret = new StringBuilder(this.httpsPrefix.length() + uri.length() + 1 + queryString.length());
            ret.append(this.httpsPrefix).append(uri).append('?').append(queryString);
            return ret.toString();
        }
        StringBuilder ret = new StringBuilder(this.httpsPrefix.length() + uri.length());
        ret.append(this.httpsPrefix).append(uri);
        return ret.toString();
    }

    protected void buildUrlPrefix(HttpServerExchange exchange) {
        String ret;
        this.httpsPrefix = ret = "https://" + exchange.getHostName() + ":" + this.config.getSslConfig().getPort();
    }
}

