/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.ext.directive;

import com.jfinal.template.Directive;
import com.jfinal.template.Env;
import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.expr.ast.ExprList;
import com.jfinal.template.io.Writer;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.time.temporal.Temporal;
import java.util.Date;

public class DateDirective
extends Directive {
    private Expr dateExpr;
    private Expr patternExpr;

    @Override
    public void setExprList(ExprList exprList) {
        int paraNum = exprList.length();
        if (paraNum == 0) {
            this.dateExpr = null;
            this.patternExpr = null;
        } else if (paraNum == 1) {
            this.dateExpr = exprList.getExpr(0);
            this.patternExpr = null;
        } else if (paraNum == 2) {
            this.dateExpr = exprList.getExpr(0);
            this.patternExpr = exprList.getExpr(1);
        } else {
            throw new ParseException("Wrong number parameter of #date directive, two parameters allowed at most", this.location);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        String pattern;
        Object date = this.dateExpr != null ? this.dateExpr.eval(scope) : new Date();
        if (this.patternExpr != null) {
            Object temp = this.patternExpr.eval(scope);
            if (!(temp instanceof String)) throw new TemplateException("The second parameter datePattern of #date directive must be String", this.location);
            pattern = (String)temp;
        } else {
            pattern = env.getEngineConfig().getDatePattern();
        }
        this.write(date, pattern, writer);
    }

    private void write(Object date, String pattern, Writer writer) {
        try {
            if (date instanceof Date) {
                writer.write((Date)date, pattern);
            } else if (date instanceof Temporal) {
                writer.write((Temporal)date, pattern);
            } else if (date != null) {
                throw new TemplateException("The first parameter of #date directive can not be " + date.getClass().getName(), this.location);
            }
        }
        catch (TemplateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

