/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.api;

import android.net.Uri;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.huike.nova.sdk.NovaSdkConfigKt;
import com.huike.nova.sdk.api.ApiDefinition;
import com.huike.nova.sdk.exceptions.NovaApiException;
import com.huike.nova.sdk.ext.JsonExtKt;
import com.huike.nova.sdk.ext.LoggerExtKt;
import com.huike.nova.sdk.model.domain.NovaSdkApiBaseJsonResponse;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001!BQ\u0012\b\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00018\u0001H\u0014\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u001c2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001dH\u0014J\u0016\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/huike/nova/sdk/api/GsonPostRequest;", "P", "T", "Lcom/android/volley/Request;", "request", "apiDefinition", "Lcom/huike/nova/sdk/api/ApiDefinition;", "listener", "Lcom/android/volley/Response$Listener;", "errorListener", "Lcom/android/volley/Response$ErrorListener;", "headers", "", "", "(Ljava/lang/Object;Lcom/huike/nova/sdk/api/ApiDefinition;Lcom/android/volley/Response$Listener;Lcom/android/volley/Response$ErrorListener;Ljava/util/Map;)V", "gson", "Lcom/google/gson/Gson;", "Ljava/lang/Object;", "uuid", "deliverResponse", "", "response", "(Ljava/lang/Object;)V", "getBody", "", "getBodyContentType", "getHeaders", "parseNetworkResponse", "Lcom/android/volley/Response;", "Lcom/android/volley/NetworkResponse;", "setRequestQueue", "requestQueue", "Lcom/android/volley/RequestQueue;", "Companion", "nova-sdk_debug"})
public final class GsonPostRequest<P, T>
extends Request<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final P request;
    @NotNull
    private final ApiDefinition<P, T> apiDefinition;
    @NotNull
    private final Response.Listener<T> listener;
    @Nullable
    private final Map<String, String> headers;
    @NotNull
    private final String uuid;
    @NotNull
    private final Gson gson;
    @NotNull
    private static final String LogTag = "NovaSdk-Network";

    public GsonPostRequest(@Nullable P request, @NotNull ApiDefinition<P, T> apiDefinition, @NotNull Response.Listener<T> listener, @NotNull Response.ErrorListener errorListener, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(apiDefinition, (String)"apiDefinition");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)errorListener, (String)"errorListener");
        super(1, Companion.getApiUrl$nova_sdk_debug(apiDefinition.getApi()), errorListener);
        this.request = request;
        this.apiDefinition = apiDefinition;
        this.listener = listener;
        this.headers = headers;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.uuid = string;
        this.gson = new Gson();
    }

    public /* synthetic */ GsonPostRequest(Object object, ApiDefinition apiDefinition, Response.Listener listener, Response.ErrorListener errorListener, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            map = null;
        }
        this(object, apiDefinition, listener, errorListener, map);
    }

    @NotNull
    public Map<String, String> getHeaders() {
        Map map = this.headers;
        if (map == null) {
            Map map2 = super.getHeaders();
            map = map2;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"super.getHeaders()");
        }
        return map;
    }

    @NotNull
    public Request<?> setRequestQueue(@Nullable RequestQueue requestQueue) {
        Request request = super.setRequestQueue(requestQueue);
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"super.setRequestQueue(requestQueue)");
        return request;
    }

    protected void deliverResponse(@Nullable T response) {
        this.listener.onResponse(response);
    }

    @NotNull
    public String getBodyContentType() {
        return "application/json;charset=utf-8";
    }

    @NotNull
    public byte[] getBody() {
        Object object = this.request;
        String bodyString = object instanceof String ? (String)this.request : (object != null ? this.gson.toJson(this.request) : "{}");
        Intrinsics.checkNotNullExpressionValue((Object)bodyString, (String)"bodyString");
        object = bodyString;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Response<T> parseNetworkResponse(@Nullable NetworkResponse response) {
        Response response2;
        try {
            Response response3;
            String reqBody = new String(this.getBody(), Charsets.UTF_8);
            String header = JsonExtKt.toJsonString(this.getHeaders());
            NetworkResponse networkResponse = response;
            byte[] byArray = (byte[])(networkResponse != null ? networkResponse.data : null);
            if (byArray == null) {
                byArray = new byte[]{};
            }
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String json = new String(byArray2, charset2);
            Object object = response;
            if (object == null || (object = ((NetworkResponse)object).headers) == null || (object = (String)object.get("ltb-trace-id")) == null) {
                object = "NIL";
            }
            Object traceId = object;
            NetworkResponse networkResponse2 = response;
            LoggerExtKt.debugLog("NovaApiTracker >> Method=" + StringsKt.replace$default((String)this.apiDefinition.getApi(), (String)"api/", (String)"", (boolean)false, (int)4, null) + "^Code=" + (networkResponse2 != null ? networkResponse2.statusCode : -1) + "^TraceId=" + (String)traceId + "^Request='" + reqBody + "'^Response='" + json + "'^ReqHeader='" + header + '\'');
            NovaSdkApiBaseJsonResponse novaResponse = (NovaSdkApiBaseJsonResponse)this.gson.fromJson(json, NovaSdkApiBaseJsonResponse.class);
            if (novaResponse.isSuccess()) {
                Object object2 = (JsonElement)novaResponse.getData();
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "{}";
                }
                response3 = Response.success((Object)this.gson.fromJson((String)object2, this.apiDefinition.getResponseClass()), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            } else {
                response3 = Response.error((VolleyError)((VolleyError)new ParseError((Throwable)new NovaApiException(novaResponse.getCode(), novaResponse.getMessage()))));
            }
            response2 = response3;
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"{\n            val reqBod\u2026)\n            }\n        }");
        }
        catch (UnsupportedEncodingException e) {
            Response response4 = Response.error((VolleyError)((VolleyError)new ParseError((Throwable)e)));
            Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"{\n            Response.e\u2026(ParseError(e))\n        }");
            response2 = response4;
        }
        catch (JsonSyntaxException e) {
            Response response5 = Response.error((VolleyError)((VolleyError)new ParseError((Throwable)e)));
            Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"{\n            Response.e\u2026(ParseError(e))\n        }");
            response2 = response5;
        }
        catch (Exception e) {
            Response response6 = Response.error((VolleyError)((VolleyError)new ParseError((Throwable)e)));
            Intrinsics.checkNotNullExpressionValue((Object)response6, (String)"{\n            Response.e\u2026(ParseError(e))\n        }");
            response2 = response6;
        }
        return response2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/huike/nova/sdk/api/GsonPostRequest$Companion;", "", "()V", "LogTag", "", "getApiUrl", "api", "getApiUrl$nova_sdk_debug", "nova-sdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getApiUrl$nova_sdk_debug(@NotNull String api) {
            Intrinsics.checkNotNullParameter((Object)api, (String)"api");
            String $this$toUri$iv = NovaSdkConfigKt.getGlobalSdkConfig().getApiUrl();
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(this)");
            String string = uri.buildUpon().encodedPath(api).build().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"globalSdkConfig.apiUrl.t\u2026              .toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

