/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ui.douyin;

import com.huike.nova.sdk.constants.enums.OrderChannelType;
import com.huike.nova.sdk.ui.douyin.TicketCodeHelper;
import com.huike.nova.sdk.utils.RegexUtil;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/huike/nova/sdk/ui/douyin/TicketCodeHelper;", "", "()V", "AlipayElements", "", "", "[Ljava/lang/String;", "AmapPrefix", "DouyinClosedLoopPattern", "Ljava/util/regex/Pattern;", "getDouyinClosedLoopPattern", "()Ljava/util/regex/Pattern;", "DouyinClosedLoopPattern$delegate", "Lkotlin/Lazy;", "DouyinOpenLoopElements", "getOrderChannelTypeByTicketCode", "Lcom/huike/nova/sdk/constants/enums/OrderChannelType;", "ticketCode", "isAlipayTicket", "", "isDouyinOpenLoopTicket", "isQykTicket", "nova-sdk_debug"})
public final class TicketCodeHelper {
    @NotNull
    public static final TicketCodeHelper INSTANCE = new TicketCodeHelper();
    @NotNull
    private static final String AmapPrefix = "GD";
    @NotNull
    private static final String[] DouyinOpenLoopElements;
    @NotNull
    private static final String[] AlipayElements;
    @NotNull
    private static final Lazy DouyinClosedLoopPattern$delegate;

    private TicketCodeHelper() {
    }

    private final Pattern getDouyinClosedLoopPattern() {
        Lazy lazy = DouyinClosedLoopPattern$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-DouyinClosedLoopPattern>(...)");
        return (Pattern)object;
    }

    @NotNull
    public final OrderChannelType getOrderChannelTypeByTicketCode(@NotNull String ticketCode) {
        Intrinsics.checkNotNullParameter((Object)ticketCode, (String)"ticketCode");
        return StringsKt.startsWith$default((String)ticketCode, (String)AmapPrefix, (boolean)false, (int)2, null) ? OrderChannelType.Amap : (this.isDouyinOpenLoopTicket(ticketCode) ? OrderChannelType.DouyinOpenLoop : (RegexUtil.INSTANCE.match(this.getDouyinClosedLoopPattern(), ticketCode) ? OrderChannelType.DouyinClosedLoop : (this.isAlipayTicket(ticketCode) ? OrderChannelType.Alipay : (this.isQykTicket(ticketCode) ? OrderChannelType.FubeiQyk : OrderChannelType.UnKnown))));
    }

    private final boolean isDouyinOpenLoopTicket(String ticketCode) {
        String[] $this$forEach$iv = DouyinOpenLoopElements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)ticketCode, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    private final boolean isAlipayTicket(String ticketCode) {
        String[] $this$forEach$iv = AlipayElements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)ticketCode, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    private final boolean isQykTicket(String ticketCode) {
        return StringsKt.startsWith((String)ticketCode, (String)"QYK", (boolean)true);
    }

    static {
        String[] stringArray = new String[]{"app_id=", "encrypted_data=", "out_order_no="};
        DouyinOpenLoopElements = stringArray;
        stringArray = new String[]{"channel_type=ALIPAY", "app_id=", "out_order_no="};
        AlipayElements = stringArray;
        DouyinClosedLoopPattern$delegate = LazyKt.lazy((Function0)DouyinClosedLoopPattern.2.INSTANCE);
    }
}

