/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.saturn.cfca;

import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import com.huifu.saturn.cfca.Base64;
import com.huifu.saturn.cfca.CFCAException;
import com.huifu.saturn.cfca.CFCAVerify;
import com.huifu.saturn.cfca.SignEnum;
import com.huifu.saturn.cfca.SignResult;
import com.huifu.saturn.cfca.VerifyEnum;
import com.huifu.saturn.cfca.VerifyResult;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFCASignature {
    private static Logger logger = LoggerFactory.getLogger(CFCASignature.class);
    private static String mechanism = "sha256WithRSAEncryption";
    static Map<String, PrivateKey> priKeyMap = new HashMap<String, PrivateKey>();
    static Map<String, X509Cert> x509CertMap = new HashMap<String, X509Cert>();
    static X509Cert[] certs = null;
    static PKCS7SignedData p7 = null;

    @Deprecated
    public static String sign(String pfxFilePath, String pfxFilePwd, String content, String charset) {
        try {
            PrivateKey priKey = KeyUtil.getPrivateKeyFromPFX((String)pfxFilePath, (String)pfxFilePwd);
            X509Cert cert = CertUtil.getCertFromPFX((String)pfxFilePath, (String)pfxFilePwd);
            Signature sigUtil = new Signature();
            byte[] signature = sigUtil.p7SignMessageAttach(mechanism, content.getBytes(Charset.forName(charset)), priKey, cert, CFCASignature.getSession());
            return new String(Base64.encodeBase64(signature));
        }
        catch (Exception e) {
            logger.error("sign error:", (Throwable)e);
            return null;
        }
    }

    public static SignResult signature(String pfxFilePath, String pfxFilePwd, String content, String charset) {
        return CFCASignature.signature(pfxFilePath, pfxFilePwd, mechanism, content, charset);
    }

    public static void loadPfx(String pfxFilePath, String pfxFilePwd) {
        try {
            PrivateKey priKey = priKeyMap.get(pfxFilePath);
            X509Cert cert = x509CertMap.get(pfxFilePath);
            if (priKey == null) {
                priKey = KeyUtil.getPrivateKeyFromPFX((String)pfxFilePath, (String)pfxFilePwd);
                priKeyMap.put(pfxFilePath, priKey);
            }
            if (cert == null) {
                cert = CertUtil.getCertFromPFX((String)pfxFilePath, (String)pfxFilePwd);
                x509CertMap.put(pfxFilePath, cert);
            }
        }
        catch (PKIException e) {
            logger.error("cfca init failed:", (Throwable)e);
        }
    }

    public static SignResult signature(String pfxFilePath, String pfxFilePwd, String mechanism, String content, String charset) {
        try {
            PrivateKey priKey = priKeyMap.get(pfxFilePath);
            X509Cert cert = x509CertMap.get(pfxFilePath);
            if (priKey == null) {
                priKey = KeyUtil.getPrivateKeyFromPFX((String)pfxFilePath, (String)pfxFilePwd);
                priKeyMap.put(pfxFilePath, priKey);
            }
            if (cert == null) {
                cert = CertUtil.getCertFromPFX((String)pfxFilePath, (String)pfxFilePwd);
                x509CertMap.put(pfxFilePath, cert);
            }
            Signature sigUtil = new Signature();
            byte[] signature = sigUtil.p7SignMessageAttach(mechanism, content.getBytes(Charset.forName(charset)), priKey, cert, CFCASignature.getSession());
            SignResult signResult = new SignResult(SignEnum.SUCCESS);
            signResult.setSign(new String(Base64.encodeBase64(signature)));
            return signResult;
        }
        catch (Exception e) {
            logger.error("signature error:", (Throwable)e);
            return new SignResult(SignEnum.FAILED);
        }
    }

    @Deprecated
    public static SignResult signResultWithSM3_SM2(String sm2FilePath, String sm2FilePwd, String content, String charset) {
        return CFCASignature.signResultWithSM3_SM2(sm2FilePath, sm2FilePwd, "sm3WithSM2Encryption", content, charset);
    }

    @Deprecated
    public static SignResult signResultWithSM3_SM2(String sm2FilePath, String sm2FilePwd, String mechanism, String content, String charset) {
        try {
            SM2PrivateKey priKey = KeyUtil.getPrivateKeyFromSM2((String)sm2FilePath, (String)sm2FilePwd);
            X509Cert cert = CertUtil.getCertFromSM2((String)sm2FilePath);
            Signature sigUtil = new Signature();
            SM2ContextConfig.setSignFormat((int)1);
            byte[] signature = sigUtil.p7SignMessageAttach(mechanism, content.getBytes(Charset.forName(charset)), (PrivateKey)priKey, cert, CFCASignature.getSession());
            SignResult signResult = new SignResult(SignEnum.SUCCESS);
            signResult.setSign(new String(Base64.encodeBase64(signature)));
            return signResult;
        }
        catch (Exception e) {
            logger.error("signature error:", (Throwable)e);
            return new SignResult(SignEnum.FAILED);
        }
    }

    public static VerifyResult verifyChinaPnRSign(String huifuId, String signature, String charset, String trustCerPath) {
        try {
            Signature sigUtil = new Signature();
            byte[] bytes = Base64.decodeBase64(signature.getBytes(Charset.forName(charset)));
            X509Cert userX509Cert = sigUtil.getSignerX509CertFromP7SignData(bytes);
            CFCAVerify.verifyCer(userX509Cert, trustCerPath);
            CFCAVerify.verifyMer(sigUtil, huifuId, bytes);
            return CFCAVerify.verifyP7VerifyMessageAttach(sigUtil, bytes, CFCASignature.getSession());
        }
        catch (CFCAException e) {
            return new VerifyResult(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("verifyChinaPnRSign error:", (Throwable)e);
            return new VerifyResult(VerifyEnum.FAILED);
        }
    }

    public static VerifyResult verifyMerSign(String merId, String signature, String charset, String trustCerPath) {
        return CFCASignature.verifyMerSign(merId, signature, charset, trustCerPath, null);
    }

    public static VerifyResult verifyMerSign(String merId, String signature, String charset, String trustCerPath, String crlFilePath) {
        try {
            Signature sigUtil = new Signature();
            byte[] bytes = Base64.decodeBase64(signature.getBytes(Charset.forName(charset)));
            X509Cert userX509Cert = sigUtil.getSignerX509CertFromP7SignData(bytes);
            CFCAVerify.verifyCerDate(userX509Cert, trustCerPath);
            CFCAVerify.verifyCer(userX509Cert, trustCerPath);
            CFCAVerify.verifyCRL(userX509Cert, crlFilePath);
            CFCAVerify.verifyMer(sigUtil, merId, bytes);
            return CFCAVerify.verifyP7VerifyMessageAttach(sigUtil, bytes, CFCASignature.getSession());
        }
        catch (CFCAException e) {
            return new VerifyResult(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("verifyMerSign error:", (Throwable)e);
            return new VerifyResult(VerifyEnum.FAILED);
        }
    }

    @Deprecated
    public static VerifyResult verifySign(String merId, String signature, String charset, String trustCerPath) {
        return CFCASignature.verifySign(merId, signature, charset, trustCerPath, null);
    }

    @Deprecated
    public static VerifyResult verifySign(String merId, String signature, String charset, String trustCerPath, String crlFilePath) {
        try {
            Signature sigUtil = new Signature();
            byte[] bytes = Base64.decodeBase64(signature.getBytes(Charset.forName(charset)));
            X509Cert userX509Cert = sigUtil.getSignerX509CertFromP7SignData(bytes);
            CFCAVerify.verifyCerDate(userX509Cert, trustCerPath);
            CFCAVerify.verifyCer(userX509Cert, trustCerPath);
            CFCAVerify.verifyCRL(userX509Cert, crlFilePath);
            CFCAVerify.verifyMer(sigUtil, merId, bytes);
            return CFCAVerify.verifyP7VerifyMessageAttach(sigUtil, bytes, CFCASignature.getSession());
        }
        catch (CFCAException e) {
            return new VerifyResult(e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error("verifySign error:", (Throwable)e);
            return new VerifyResult(VerifyEnum.FAILED);
        }
    }

    public static Session getSession() throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        return JCrypto.getInstance().openSession("JSOFT_LIB");
    }

    public static String getMechanism() {
        return mechanism;
    }

    public static void setMechanism(String mechanism) {
        CFCASignature.mechanism = mechanism;
    }
}

