/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.resources;

import com.googlecode.t7mp.steps.Context;
import com.googlecode.t7mp.steps.Step;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class SetSystemPropertiesStep
implements Step {
    @Override
    public void execute(Context context) {
        String catalinaBasPath = context.getMojo().getCatalinaBase().getAbsolutePath();
        Log log = context.getLog();
        System.setProperty("catalina.home", catalinaBasPath);
        log.debug((CharSequence)("set systemproperty key: catalina.home to value " + catalinaBasPath));
        System.setProperty("catalina.base", catalinaBasPath);
        log.debug((CharSequence)("set systemproperty key: catalina.base to value " + catalinaBasPath));
        Map<String, String> properties = context.getMojo().getSystemProperties();
        for (String key : properties.keySet()) {
            String value = this.replaceCatalinas(properties.get(key));
            System.setProperty(key, value);
            log.debug((CharSequence)("set systemproperty key: " + key + " to value: " + System.getProperty(key)));
        }
    }

    protected String replaceCatalinas(String value) {
        if (value.startsWith("${catalina.home}")) {
            value = value.replace("${catalina.home}", System.getProperty("catalina.home"));
        }
        if (value.startsWith("${catalina.base}")) {
            value = value.replace("${catalina.base}", System.getProperty("catalina.base"));
        }
        return value;
    }
}

