/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.deployment;

import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.steps.Context;
import com.googlecode.t7mp.steps.Step;
import com.googlecode.t7mp.steps.deployment.MyArtifactResolver;
import com.googlecode.t7mp.util.ZipUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.aether.util.StringUtils;

public class ResolveTomcatStep
implements Step {
    public static final String TOMCAT_GROUPID = "com.googlecode.t7mp";
    public static final String TOMCAT_ARTIFACTID = "tomcat";
    public static final String TOMCAT_TYPE = "zip";
    protected AbstractT7Mojo mojo;
    protected MyArtifactResolver myArtifactResolver;
    protected Log logger;

    @Override
    public void execute(Context context) {
        this.mojo = context.getMojo();
        this.myArtifactResolver = new MyArtifactResolver(context.getMojo());
        this.logger = context.getMojo().getLog();
        String version = null;
        String configuredVersion = context.getMojo().getTomcatVersion();
        if (context.getMojo().isDownloadTomcatExamples()) {
            this.logger.info((CharSequence)"Resolve Tomcat with 'docs' and 'examples'");
            version = configuredVersion;
        } else {
            this.logger.info((CharSequence)"Resolve Tomcat without 'docs' and 'examples'.");
            version = configuredVersion + ".A";
        }
        if (StringUtils.isEmpty((String)version)) {
            throw new TomcatSetupException("Version should not be null or empty.");
        }
        File unpackDirectory = null;
        try {
            Artifact artifact = this.resolveTomcatArtifact(version);
            unpackDirectory = this.getUnpackDirectory();
            ZipUtil.unzip(artifact.getFile(), unpackDirectory);
            this.copyToTomcatDirectory(unpackDirectory);
        }
        catch (MojoExecutionException e) {
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
            throw new TomcatSetupException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
            throw new TomcatSetupException(e.getMessage(), e);
        }
        finally {
            if (unpackDirectory != null) {
                try {
                    FileUtils.deleteDirectory((File)unpackDirectory);
                }
                catch (IOException e) {
                    this.logger.error((CharSequence)("Could not delete tomcat upack directory : " + unpackDirectory.getAbsolutePath()));
                    this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void copyToTomcatDirectory(File unpackDirectory) throws IOException {
        File[] files = unpackDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        FileUtils.copyDirectory((File)files[0], (File)this.mojo.getCatalinaBase());
    }

    protected Artifact resolveTomcatArtifact(String tomcatVersion) throws MojoExecutionException {
        Artifact artifact = this.myArtifactResolver.resolve(TOMCAT_GROUPID, TOMCAT_ARTIFACTID, tomcatVersion, null, TOMCAT_TYPE, "compile");
        return artifact;
    }

    protected File getUnpackDirectory() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File upackDirectory = new File(tempDir, UUID.randomUUID().toString());
        upackDirectory.mkdirs();
        return upackDirectory;
    }
}

