/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp.steps.deployment;

import com.google.common.collect.Lists;
import com.googlecode.t7mp.AbstractArtifact;
import com.googlecode.t7mp.SetupUtil;
import com.googlecode.t7mp.TomcatSetupException;
import com.googlecode.t7mp.steps.Context;
import com.googlecode.t7mp.steps.Step;
import com.googlecode.t7mp.steps.deployment.MyArtifactResolver;
import com.googlecode.t7mp.util.CommonsSetupUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractDeploymentStep
implements Step {
    protected SetupUtil setupUtil = new CommonsSetupUtil();
    protected MyArtifactResolver myArtifactResolver;
    protected Context context;

    @Override
    public void execute(Context context) {
        this.context = context;
        this.myArtifactResolver = new MyArtifactResolver(context.getMojo());
        List<AbstractArtifact> artifactList = this.getArtifactList();
        artifactList = this.resolveArtifacts(artifactList);
        this.deployArtifacts(artifactList);
    }

    protected abstract List<AbstractArtifact> getArtifactList();

    protected String createTargetFileName(AbstractArtifact abstractArtifact) {
        return abstractArtifact.getArtifactId() + "-" + abstractArtifact.getVersion() + "." + abstractArtifact.getType();
    }

    protected void deployArtifacts(List<AbstractArtifact> artifactList) {
        for (AbstractArtifact artifact : artifactList) {
            try {
                String targetFileName = this.createTargetFileName(artifact);
                File sourceFile = artifact.getArtifact().getFile();
                File targetFile = new File(this.context.getMojo().getCatalinaBase(), "/lib/" + targetFileName);
                this.context.getLog().debug((CharSequence)("Copy artifact from " + sourceFile.getAbsolutePath() + " to " + targetFile.getAbsolutePath()));
                this.setupUtil.copy(new FileInputStream(sourceFile), new FileOutputStream(targetFile));
            }
            catch (IOException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
        }
    }

    protected List<AbstractArtifact> resolveArtifacts(List<? extends AbstractArtifact> artifacts) {
        ArrayList resolvedArtifacts = Lists.newArrayList();
        for (AbstractArtifact abstractArtifact : artifacts) {
            Artifact artifact;
            this.context.getLog().debug((CharSequence)("Resolve artifact for " + abstractArtifact.toString()));
            if (!abstractArtifact.getGroupId().equals("local")) {
                try {
                    artifact = this.myArtifactResolver.resolve(abstractArtifact.getGroupId(), abstractArtifact.getArtifactId(), abstractArtifact.getVersion(), abstractArtifact.getClassifier(), abstractArtifact.getType(), "compile");
                }
                catch (MojoExecutionException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
                abstractArtifact.setArtifact(artifact);
                resolvedArtifacts.add(abstractArtifact);
                continue;
            }
            artifact = new DefaultArtifact(abstractArtifact.getGroupId(), abstractArtifact.getArtifactId(), VersionRange.createFromVersion((String)abstractArtifact.getVersion()), "compile", abstractArtifact.getType(), null, (ArtifactHandler)new DefaultArtifactHandler("jar"), false);
            String resourceName = "/com/googlecode/t7mp/repo/" + abstractArtifact.getArtifactId() + "/" + abstractArtifact.getVersion() + "/" + abstractArtifact.getArtifactId() + "-" + abstractArtifact.getVersion() + ".jar";
            BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream(resourceName));
            try {
                File tempFile = File.createTempFile("local_Artifact", ".maven.tmp");
                tempFile.deleteOnExit();
                IOUtils.copy((InputStream)bis, (OutputStream)new FileOutputStream(tempFile));
                artifact.setFile(tempFile);
                abstractArtifact.setArtifact(artifact);
                resolvedArtifacts.add(abstractArtifact);
            }
            catch (FileNotFoundException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new TomcatSetupException(e.getMessage(), e);
            }
        }
        return resolvedArtifacts;
    }
}

