/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.ShutdownHook;
import com.googlecode.t7mp.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ForkedTomcatProcessShutdownHook
extends Thread
implements ShutdownHook {
    private final Process tomcatProcess;
    private final Log log;
    private final List<Scanner> scanners = new ArrayList<Scanner>();

    public ForkedTomcatProcessShutdownHook(Process tomcatProcess, Log log) {
        this.tomcatProcess = tomcatProcess;
        this.log = log;
    }

    @Override
    public void run() {
        this.log.info((CharSequence)"Stopping tomcatProcess ...");
        this.stopScanners();
        this.tomcatProcess.destroy();
        int returnValue = -1;
        try {
            returnValue = this.tomcatProcess.waitFor();
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)"error when waiting for destroying tomcatProcess", (Throwable)e);
        }
        this.log.info((CharSequence)("... tomcatProcess stopped. ReturnValue:" + returnValue));
    }

    @Override
    public void addScanner(Scanner scanner) {
        this.scanners.add(scanner);
    }

    @Override
    public void stopScanners() {
        for (Scanner scanner : this.scanners) {
            scanner.stop();
        }
    }
}

