/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.core.validators.LessAstValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonToken;

public class ASTBuilder {
    private final ProblemsHandler problemsHandler;

    public ASTBuilder(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public StyleSheet parseStyleSheet(HiddenTokenAwareTree tree) {
        ASTCssNode result = this.parseAnything(tree);
        return (StyleSheet)result;
    }

    public VariableDeclaration parseVariable(String name, HiddenTokenAwareTree valueTree) {
        Expression value = (Expression)this.parseAnything(valueTree);
        Variable variable = new Variable(value.getUnderlyingStructure(), name);
        VariableDeclaration result = new VariableDeclaration(value.getUnderlyingStructure(), variable, value);
        result.configureParentToAllChilds();
        return result;
    }

    public List<VariableDeclaration> parseVariables(Map<String, HiddenTokenAwareTree> variables) {
        ArrayList<VariableDeclaration> result = new ArrayList<VariableDeclaration>();
        for (Map.Entry<String, HiddenTokenAwareTree> entry : variables.entrySet()) {
            result.add(this.parseVariable(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public ASTCssNode parseAnything(HiddenTokenAwareTree tree) {
        ASTBuilderSwitch builder = new ASTBuilderSwitch(this.problemsHandler);
        ASTCssNode result = (ASTCssNode)builder.switchOn(tree);
        this.convertComments(result);
        this.solveParentChildRelationShips(result);
        this.checkForWarnings(result);
        return result;
    }

    private void checkForWarnings(ASTCssNode result) {
        LessAstValidator validator = new LessAstValidator(this.problemsHandler);
        validator.validate(result);
    }

    private void solveParentChildRelationShips(ASTCssNode node) {
        for (ASTCssNode aSTCssNode : node.getChilds()) {
            aSTCssNode.setParent(node);
            this.solveParentChildRelationShips(aSTCssNode);
        }
    }

    private void convertComments(ASTCssNode node) {
        this.inheritCommentsFromToken(node);
        for (ASTCssNode aSTCssNode : node.getChilds()) {
            this.convertComments(aSTCssNode);
        }
    }

    private void inheritCommentsFromToken(ASTCssNode node) {
        HiddenTokenAwareTree underlyingStructure = node.getUnderlyingStructure();
        if (underlyingStructure == null) {
            return;
        }
        LessSource source = underlyingStructure.getSource();
        List<Comment> preceding = this.convertToComments(underlyingStructure.getPreceding(), source);
        node.setOpeningComments(preceding);
        List<Comment> following = this.convertToComments(underlyingStructure.getFollowing(), source);
        node.setTrailingComments(following);
        List<Comment> orphans = this.convertToComments(underlyingStructure.getOrphans(), source);
        node.setOrphanComments(orphans);
    }

    private List<Comment> convertToComments(List<CommonToken> preceding, LessSource source) {
        ArrayList<Comment> result = new ArrayList<Comment>();
        Comment comment = null;
        for (CommonToken token : preceding) {
            if (token.getType() == 180) {
                comment = new Comment(new HiddenTokenAwareTree(token, source));
                result.add(comment);
            }
            if (token.getType() != 194 || comment == null) continue;
            comment.setHasNewLine(true);
        }
        return result;
    }
}

