/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.DetachedRuleset;
import com.github.sommeri.less4j.core.ast.DetachedRulesetReference;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.KeywordExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionManipulator;
import com.github.sommeri.less4j.core.compiler.expressions.GuardValue;
import com.github.sommeri.less4j.core.compiler.expressions.MixinsGuardsValidator;
import com.github.sommeri.less4j.core.compiler.scopes.FoundMixin;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.InScopeSnapshotRunner;
import com.github.sommeri.less4j.core.compiler.scopes.ScopeFactory;
import com.github.sommeri.less4j.core.compiler.scopes.view.ScopeView;
import com.github.sommeri.less4j.core.compiler.stages.ArgumentsBuilder;
import com.github.sommeri.less4j.core.compiler.stages.AstNodesStack;
import com.github.sommeri.less4j.core.compiler.stages.BodyCompilationData;
import com.github.sommeri.less4j.core.compiler.stages.CallerCalleeScopeJoiner;
import com.github.sommeri.less4j.core.compiler.stages.DefaultGuardHelper;
import com.github.sommeri.less4j.core.compiler.stages.EvaluatedMixinReferenceCall;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.compiler.stages.ReturnMode;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.core.problems.UnableToFinish;
import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.Couple;
import java.util.ArrayList;
import java.util.List;

class MixinsRulesetsSolver {
    private final ProblemsHandler problemsHandler;
    private final ReferencesSolver parentSolver;
    private final AstNodesStack semiCompiledNodes;
    private final LessCompiler.Configuration configuration;
    private final DefaultGuardHelper defaultGuardHelper;
    private final CallerCalleeScopeJoiner scopeManipulation = new CallerCalleeScopeJoiner();
    private final ExpressionManipulator expressionManipulator = new ExpressionManipulator();

    public MixinsRulesetsSolver(ReferencesSolver parentSolver, AstNodesStack semiCompiledNodes, ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.parentSolver = parentSolver;
        this.semiCompiledNodes = semiCompiledNodes;
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
        this.defaultGuardHelper = new DefaultGuardHelper(problemsHandler);
    }

    private Couple<List<ASTCssNode>, IScope> resolveCalledBody(final IScope callerScope, final BodyOwner<?> bodyOwner, final IScope referencedMixinScope, final ReturnMode returnMode) {
        final ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(referencedMixinScope, this.problemsHandler, this.configuration);
        return InScopeSnapshotRunner.runInLocalDataSnapshot(referencedMixinScope, new InScopeSnapshotRunner.IFunction<Couple<List<ASTCssNode>, IScope>>(){

            @Override
            public Couple<List<ASTCssNode>, IScope> run() {
                List replacement = MixinsRulesetsSolver.this.compileBody(bodyOwner.getBody(), referencedMixinScope);
                IScope returnValues = ScopeFactory.createDummyScope();
                if (returnMode == ReturnMode.MIXINS_AND_VARIABLES) {
                    returnValues.addFilteredVariables(new ImportedScopeFilter(expressionEvaluator, callerScope), referencedMixinScope);
                }
                List<FullMixinDefinition> unmodifiedMixinsToImport = referencedMixinScope.getAllMixins();
                List<FullMixinDefinition> allMixinsToImport = MixinsRulesetsSolver.this.scopeManipulation.mixinsToImport(callerScope, referencedMixinScope, unmodifiedMixinsToImport);
                returnValues.addAllMixins(allMixinsToImport);
                return new Couple<List<ASTCssNode>, IScope>(replacement, returnValues);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ASTCssNode> compileBody(Body body, IScope scopeSnapshot) {
        this.semiCompiledNodes.push(body.getParent());
        try {
            Body bodyClone = body.clone();
            this.parentSolver.unsafeDoSolveReferences((ASTCssNode)bodyClone, scopeSnapshot);
            List<ASTCssNode> list = bodyClone.getMembers();
            return list;
        }
        finally {
            this.semiCompiledNodes.pop();
        }
    }

    private void shiftComments(ASTCssNode reference, GeneralBody result) {
        List<ASTCssNode> childs = result.getMembers();
        if (!childs.isEmpty()) {
            childs.get(0).addOpeningComments(reference.getOpeningComments());
            childs.get(childs.size() - 1).addTrailingComments(reference.getTrailingComments());
        }
    }

    private IScope buildMixinsArguments(EvaluatedMixinReferenceCall evaluatedReference, IScope referenceScope, FullMixinDefinition mixin) {
        ArgumentsBuilder builder = new ArgumentsBuilder(evaluatedReference, mixin.getMixin(), this.problemsHandler);
        return builder.build();
    }

    public GeneralBody buildMixinReferenceReplacement(final EvaluatedMixinReferenceCall evaluatedReference, final IScope callerScope, List<FoundMixin> mixins) {
        MixinReference reference = evaluatedReference.getReference();
        if (Thread.currentThread().isInterrupted()) {
            throw new UnableToFinish("Thread Interrupted", (ASTCssNode)null);
        }
        final GeneralBody result = new GeneralBody(reference.getUnderlyingStructure());
        if (mixins.isEmpty()) {
            return result;
        }
        final ArrayList<BodyCompilationData> compiledMixins = new ArrayList<BodyCompilationData>();
        for (final FoundMixin fullMixin : mixins) {
            final ReusableStructure mixin = fullMixin.getMixin();
            final IScope mixinScope = fullMixin.getScope();
            final BodyCompilationData data = new BodyCompilationData(mixin);
            InScopeSnapshotRunner.runInLocalDataSnapshot(mixinScope.getParent(), new InScopeSnapshotRunner.ITask(){

                @Override
                public void run() {
                    IScope mixinArguments = MixinsRulesetsSolver.this.buildMixinsArguments(evaluatedReference, callerScope, fullMixin);
                    data.setArguments(mixinArguments);
                    mixinScope.getParent().add(mixinArguments);
                    ScopeView mixinWorkingScope = MixinsRulesetsSolver.this.scopeManipulation.joinIfIndependent(callerScope, mixinScope);
                    mixinWorkingScope.toIndependentWorkingCopy();
                    data.setMixinWorkingScope(mixinWorkingScope);
                    MixinsGuardsValidator guardsValidator = new MixinsGuardsValidator(mixinWorkingScope, MixinsRulesetsSolver.this.problemsHandler, MixinsRulesetsSolver.this.configuration);
                    GuardValue guardValue = guardsValidator.evaluateGuards(fullMixin.getGuardsOnPath(), mixin);
                    data.setGuardValue(guardValue);
                    compiledMixins.add(data);
                }
            });
        }
        List<BodyCompilationData> mixinsToBeUsed = this.defaultGuardHelper.chooseMixinsToBeUsed(compiledMixins, reference);
        for (final BodyCompilationData data : mixinsToBeUsed) {
            final ScopeView mixinWorkingScope = data.getMixinWorkingScope();
            InScopeSnapshotRunner.runInLocalDataSnapshot((IScope)mixinWorkingScope.getParent(), new InScopeSnapshotRunner.ITask(){

                @Override
                public void run() {
                    BodyOwner<?> mixin = data.getCompiledBodyOwner();
                    IScope arguments = data.getArguments();
                    mixinWorkingScope.getParent().add(arguments);
                    Couple compiled = MixinsRulesetsSolver.this.resolveCalledBody(callerScope, mixin, mixinWorkingScope, ReturnMode.MIXINS_AND_VARIABLES);
                    result.addMembers((List)compiled.getT());
                    callerScope.addToDataPlaceholder((IScope)compiled.getM());
                }
            });
        }
        callerScope.closeDataPlaceholder();
        this.resolveImportance(reference, result);
        this.shiftComments(reference, result);
        return result;
    }

    public GeneralBody buildDetachedRulesetReplacement(DetachedRulesetReference reference, IScope callerScope, DetachedRuleset detachedRuleset, IScope detachedRulesetScope) {
        ScopeView mixinWorkingScope = this.scopeManipulation.joinIfIndependent(callerScope, detachedRulesetScope);
        Couple<List<ASTCssNode>, IScope> compiled = this.resolveCalledBody(callerScope, detachedRuleset, mixinWorkingScope, ReturnMode.MIXINS);
        GeneralBody result = new GeneralBody(reference.getUnderlyingStructure());
        result.addMembers(compiled.getT());
        callerScope.addToDataPlaceholder(compiled.getM());
        callerScope.closeDataPlaceholder();
        this.shiftComments(reference, result);
        return result;
    }

    private void resolveImportance(MixinReference reference, GeneralBody result) {
        if (reference.isImportant()) {
            this.declarationsAreImportant(result);
        }
    }

    private void declarationsAreImportant(Body result) {
        for (ASTCssNode kid : result.getMembers()) {
            if (kid instanceof Declaration) {
                Declaration declaration = (Declaration)kid;
                this.addImportantKeyword(declaration);
                continue;
            }
            if (!(kid instanceof BodyOwner)) continue;
            BodyOwner owner = (BodyOwner)((Object)kid);
            this.declarationsAreImportant((Body)owner.getBody());
        }
    }

    private void addImportantKeyword(Declaration declaration) {
        Expression expression = declaration.getExpression();
        if (this.expressionManipulator.isImportant(expression)) {
            return;
        }
        HiddenTokenAwareTree underlying = expression != null ? expression.getUnderlyingStructure() : declaration.getUnderlyingStructure();
        KeywordExpression important = this.createImportantKeyword(underlying);
        ListExpression list = this.expressionManipulator.findRightmostSpaceSeparatedList(expression);
        if (list == null) {
            list = new ListExpression(underlying, ArraysUtils.asNonNullList(expression), new ListExpressionOperator(underlying, ListExpressionOperator.Operator.EMPTY_OPERATOR));
        }
        list.addExpression(important);
        list.configureParentToAllChilds();
        declaration.setExpression(list);
        list.setParent(declaration);
    }

    private KeywordExpression createImportantKeyword(HiddenTokenAwareTree underlyingStructure) {
        return new KeywordExpression(underlyingStructure, "!important", true);
    }

    class ImportedScopeFilter
    implements ExpressionFilter {
        private final ExpressionEvaluator expressionEvaluator;
        private final IScope importTargetScope;
        private final CallerCalleeScopeJoiner scopeManipulation = new CallerCalleeScopeJoiner();

        public ImportedScopeFilter(ExpressionEvaluator expressionEvaluator, IScope importTargetScope) {
            this.expressionEvaluator = expressionEvaluator;
            this.importTargetScope = importTargetScope;
        }

        @Override
        public Expression apply(Expression input) {
            Expression result = this.expressionEvaluator.evaluate(input);
            IScope newScope = this.apply(result.getScope());
            result.setScope(newScope);
            return result;
        }

        private IScope apply(IScope input) {
            if (input == null) {
                return this.importTargetScope;
            }
            return this.scopeManipulation.joinIfIndependentAndPreserveContent(this.importTargetScope, input);
        }

        @Override
        public boolean accepts(String name, Expression value) {
            return true;
        }
    }
}

