/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.MultiTargetExtend;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.Supports;
import com.github.sommeri.less4j.core.ast.SyntaxOnlyElement;
import com.github.sommeri.less4j.core.compiler.selectors.GeneralComparatorForExtend;
import com.github.sommeri.less4j.core.compiler.selectors.PerformedExtendsDB;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class ExtendsSolver {
    private GeneralComparatorForExtend comparator = new GeneralComparatorForExtend();
    private ASTManipulator manipulator = new ASTManipulator();
    private List<RuleSet> allRulesets = new ArrayList<RuleSet>();
    private List<Selector> inlineExtends = new ArrayList<Selector>();
    private PerformedExtendsDB performedExtends = new PerformedExtendsDB();

    public void solveExtends(ASTCssNode node) {
        this.collectRulesets(node);
        this.solveInlineExtends();
    }

    private void solveInlineExtends() {
        for (Selector selector : this.inlineExtends) {
            this.solveInlineExtends(selector);
        }
    }

    private void solveInlineExtends(Selector extendingSelector) {
        for (RuleSet ruleSet : this.allRulesets) {
            ArrayList<Selector> selectors = new ArrayList<Selector>(ruleSet.getSelectors());
            for (Selector targetSelector : selectors) {
                Selector newSelector = this.constructNewSelector(extendingSelector, targetSelector);
                if (newSelector == null || !this.canExtend(extendingSelector, newSelector, ruleSet)) continue;
                this.doTheExtend(extendingSelector, newSelector, ruleSet, targetSelector);
            }
        }
    }

    private void doTheExtend(Selector extendingSelector, Selector newSelector, RuleSet ruleSet, Selector targetSelector) {
        this.addSelector(ruleSet, newSelector);
        this.performedExtends.register(extendingSelector, targetSelector);
        List<Selector> thoseWhoExtendedExtending = this.performedExtends.getPreviousExtending(extendingSelector);
        for (Selector extendedExtending : thoseWhoExtendedExtending) {
            if (!this.canExtend(extendedExtending, ruleSet)) continue;
            this.doTheExtend(extendedExtending, extendedExtending.clone(), ruleSet, targetSelector);
        }
    }

    private boolean canExtend(Selector extendingSelector, RuleSet targetRuleSet) {
        return this.canExtend(extendingSelector, extendingSelector, targetRuleSet);
    }

    private boolean canExtend(Selector extendingSelector, Selector newSelector, RuleSet targetRuleSet) {
        if (this.containsSelector(newSelector, targetRuleSet)) {
            return false;
        }
        return this.compatibleMediaLocation(extendingSelector, targetRuleSet);
    }

    private boolean compatibleMediaLocation(Selector extendingSelector, RuleSet targetRuleSet) {
        ASTCssNode grandParent = this.findOwnerNode(extendingSelector);
        if (grandParent == null || grandParent.getType() == ASTCssNodeType.STYLE_SHEET) {
            return true;
        }
        return grandParent == this.findOwnerNode(targetRuleSet);
    }

    private boolean containsSelector(Selector extendingSelector, RuleSet targetRuleSet) {
        for (Selector selector : targetRuleSet.getSelectors()) {
            if (!this.comparator.equals(selector, extendingSelector)) continue;
            return true;
        }
        return false;
    }

    private ASTCssNode findOwnerNode(ASTCssNode extendingSelector) {
        return this.manipulator.findParentOfType(extendingSelector, ASTCssNodeType.STYLE_SHEET, ASTCssNodeType.MEDIA);
    }

    private void addSelector(RuleSet ruleSet, Selector selector) {
        selector.setParent(ruleSet);
        ruleSet.addSelector(selector);
        this.setVisibility(ruleSet, selector);
    }

    private void setVisibility(RuleSet ruleSet, Selector newSelector) {
        if (newSelector.isSilent() || !ruleSet.isSilent()) {
            return;
        }
        ruleSet.setSilent(false);
        ASTCssNode node = ruleSet;
        while (node.hasParent()) {
            node = node.getParent();
            this.setNecessaryParentVisibility(node, false);
        }
        List<? extends ASTCssNode> childs = ruleSet.getChilds();
        childs.removeAll(ruleSet.getSelectors());
        for (ASTCssNode aSTCssNode : childs) {
            this.manipulator.setTreeSilentness(aSTCssNode, false);
        }
    }

    private void setNecessaryParentVisibility(ASTCssNode node, boolean isSilent) {
        switch (node.getType()) {
            case GENERAL_BODY: {
                node.setSilent(isSilent);
                GeneralBody body = (GeneralBody)node;
                this.safeSetSilent(body.getOpeningCurlyBrace(), isSilent);
                this.safeSetSilent(body.getClosingCurlyBrace(), isSilent);
                break;
            }
            case MEDIA: {
                node.setSilent(isSilent);
                Media media = (Media)node;
                for (MediaQuery medium : media.getMediums()) {
                    this.manipulator.setTreeSilentness(medium, isSilent);
                }
                break;
            }
            case SUPPORTS: {
                node.setSilent(isSilent);
                Supports supports = (Supports)node;
                this.manipulator.setTreeSilentness(supports.getCondition(), isSilent);
                break;
            }
        }
    }

    private void safeSetSilent(SyntaxOnlyElement node, boolean isSilent) {
        if (node != null) {
            node.setSilent(isSilent);
        }
    }

    private Selector constructNewSelector(Selector extending, Selector possibleTarget) {
        if (possibleTarget == extending) {
            return null;
        }
        List<Extend> allExtends = extending.getExtend();
        for (Extend extend : allExtends) {
            Selector addSelector;
            if (!extend.isAll() && this.comparator.equals(possibleTarget, extend.getTarget())) {
                return this.setNewSelectorVisibility(extend, extending.clone());
            }
            if (!extend.isAll() || (addSelector = this.comparator.replaceInside(extend.getTarget(), possibleTarget, extend.getParentAsSelector())) == null) continue;
            return this.setNewSelectorVisibility(extend, addSelector);
        }
        return null;
    }

    private Selector setNewSelectorVisibility(Extend extend, Selector newSelector) {
        this.manipulator.setTreeSilentness(newSelector, extend.isSilent());
        return newSelector;
    }

    private void collectRulesets(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                RuleSet ruleset = (RuleSet)node;
                this.allRulesets.add(ruleset);
                this.collectExtendingSelectors(ruleset);
                break;
            }
            default: {
                ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
                for (ASTCssNode aSTCssNode : childs) {
                    this.collectRulesets(aSTCssNode);
                }
            }
        }
    }

    private void collectExtendingSelectors(RuleSet ruleset) {
        List<Extend> directExtends = this.collectDirectExtendDeclarations(ruleset);
        for (Selector selector : ruleset.getSelectors()) {
            this.addClones(selector, directExtends);
            if (!selector.isExtending()) continue;
            this.inlineExtends.add(selector);
        }
    }

    private void addClones(Selector selector, List<Extend> newExtends) {
        List<Extend> clones = ArraysUtils.deeplyClonedList(newExtends);
        selector.addExtends(clones);
        for (Extend extend : clones) {
            extend.setParent(selector);
        }
    }

    private List<Extend> collectDirectExtendDeclarations(RuleSet ruleset) {
        ArrayList<Extend> result = new ArrayList<Extend>();
        ArrayList<ASTCssNode> members = new ArrayList<ASTCssNode>(ruleset.getBody().getMembers());
        for (ASTCssNode node : members) {
            ASTCssNode extend;
            if (node.getType() == ASTCssNodeType.EXTEND) {
                extend = (Extend)node;
                this.manipulator.removeFromBody(extend);
                result.add((Extend)extend);
                continue;
            }
            if (node.getType() != ASTCssNodeType.MULTI_TARGET_EXTEND) continue;
            extend = (MultiTargetExtend)node;
            this.manipulator.removeFromBody(extend);
            result.addAll(((MultiTargetExtend)extend).getAllExtends());
        }
        return result;
    }
}

