/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import sockslib.client.Socks5DatagramSocket;
import sockslib.client.SocksProxy;
import sockslib.utils.Telnet;

public final class UDPTelnet
implements Telnet {
    private SocksProxy proxy;

    public UDPTelnet() {
    }

    public UDPTelnet(SocksProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public byte[] request(byte[] sendData, String host, int port) throws IOException {
        return this.request(sendData, new InetSocketAddress(host, port));
    }

    @Override
    public byte[] request(byte[] sendData, SocketAddress address) throws IOException {
        DatagramSocket socket = null;
        socket = this.proxy != null ? new Socks5DatagramSocket(this.proxy) : new DatagramSocket();
        socket.send(new DatagramPacket(sendData, sendData.length, address));
        byte[] buffer = new byte[1024];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        socket.receive(packet);
        return Arrays.copyOf(packet.getData(), packet.getLength());
    }

    public SocksProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(SocksProxy proxy) {
        this.proxy = proxy;
    }
}

