/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import sockslib.client.SocksProxy;
import sockslib.client.SocksSocket;
import sockslib.utils.ResourceUtil;
import sockslib.utils.Telnet;
import sockslib.utils.TelnetSocketInitializer;

public final class TCPTelnet
implements Telnet {
    private TelnetSocketInitializer socketInitializer;
    private SocksProxy proxy;

    public TCPTelnet() {
    }

    public TCPTelnet(SocksProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public byte[] request(byte[] outputBytes, String host, int port) throws IOException {
        return this.request(outputBytes, new InetSocketAddress(host, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] request(byte[] outputBytes, SocketAddress address) throws IOException {
        IOException exception;
        byte[] response;
        block8: {
            BufferedInputStream inputStream = null;
            BufferedOutputStream outputStream = null;
            ByteArrayOutputStream cache = null;
            Socket socket = null;
            socket = this.proxy != null ? new SocksSocket(this.proxy) : new Socket();
            response = null;
            exception = null;
            try {
                if (this.socketInitializer != null) {
                    socket = this.socketInitializer.init(socket);
                }
                socket.connect(address);
                outputStream = new BufferedOutputStream(socket.getOutputStream());
                inputStream = new BufferedInputStream(socket.getInputStream());
                ((OutputStream)outputStream).write(outputBytes);
                ((OutputStream)outputStream).flush();
                cache = new ByteArrayOutputStream();
                byte[] buffer = new byte[5120];
                int length = 0;
                while ((length = ((InputStream)inputStream).read(buffer)) > 0) {
                    cache.write(buffer, 0, length);
                }
                response = cache.toByteArray();
                ResourceUtil.close(inputStream);
            }
            catch (IOException e) {
                exception = e;
                break block8;
            }
            finally {
                ResourceUtil.close(inputStream);
                ResourceUtil.close(outputStream);
                ResourceUtil.close(socket);
            }
            ResourceUtil.close(outputStream);
            ResourceUtil.close(socket);
        }
        if (exception != null) {
            throw exception;
        }
        return response;
    }

    public TelnetSocketInitializer getSocketInitializer() {
        return this.socketInitializer;
    }

    public void setSocketInitializer(TelnetSocketInitializer socketInitializer) {
        this.socketInitializer = socketInitializer;
    }

    public SocksProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(SocksProxy proxy) {
        this.proxy = proxy;
    }
}

