/*
 * Decompiled with CFR 0.152.
 */
package sockslib.utils;

import com.google.common.base.Preconditions;
import sockslib.utils.UnsignedByte;

public class LogMessageBuilder {
    public static String build(byte[] bytes, MsgType type) {
        return LogMessageBuilder.build(bytes, bytes.length, type);
    }

    public static String build(byte[] bytes, int size, MsgType type) {
        Preconditions.checkNotNull((Object)bytes, (Object)"Argument [bytes] may not be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Argument [type] may not be null");
        StringBuilder debugMsg = new StringBuilder();
        switch (type) {
            case RECEIVE: {
                debugMsg.append("Received: ");
                break;
            }
            case SEND: {
                debugMsg.append("Sent: ");
                break;
            }
        }
        for (int i = 0; i < size; ++i) {
            int x = UnsignedByte.toInt(bytes[i]);
            debugMsg.append(Integer.toHexString(x)).append(" ");
        }
        return debugMsg.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"Argument [bytes] may not be null");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            buffer.append(UnsignedByte.toHexString(bytes[i]));
            if (i >= bytes.length - 1) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public static enum MsgType {
        SEND,
        RECEIVE;

    }
}

