/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.msg;

import java.io.IOException;
import java.io.InputStream;
import sockslib.common.SocksException;
import sockslib.common.UsernamePasswordCredentials;
import sockslib.server.msg.ReadableMessage;
import sockslib.server.msg.WritableMessage;
import sockslib.utils.StreamUtil;

public class UsernamePasswordMessage
implements ReadableMessage,
WritableMessage {
    private UsernamePasswordCredentials credentials;
    private int version = 1;
    private int usernameLength;
    private int passwordLength;
    private String username;
    private String password;

    public UsernamePasswordMessage() {
    }

    public UsernamePasswordMessage(String username, String password) {
        this.username = username;
        this.password = password;
        this.usernameLength = username.getBytes().length;
        this.passwordLength = password.getBytes().length;
    }

    @Override
    public byte[] getBytes() {
        int i;
        int SIZE = 3 + this.usernameLength + this.passwordLength;
        byte[] bytes = new byte[SIZE];
        bytes[0] = (byte)this.version;
        bytes[1] = (byte)this.usernameLength;
        for (i = 0; i < this.usernameLength; ++i) {
            bytes[2 + i] = this.username.getBytes()[i];
        }
        bytes[2 + this.usernameLength] = (byte)this.passwordLength;
        for (i = 0; i < this.passwordLength; ++i) {
            bytes[3 + this.usernameLength + i] = this.password.getBytes()[i];
        }
        return bytes;
    }

    @Override
    public int getLength() {
        return this.getBytes().length;
    }

    @Override
    public void read(InputStream inputStream) throws SocksException, IOException {
        this.version = StreamUtil.checkEnd(inputStream.read());
        this.usernameLength = StreamUtil.checkEnd(inputStream.read());
        this.username = StreamUtil.readString(inputStream, this.usernameLength);
        this.passwordLength = StreamUtil.checkEnd(inputStream.read());
        this.password = StreamUtil.readString(inputStream, this.passwordLength);
        this.credentials = new UsernamePasswordCredentials(this.username, this.password);
    }

    public int getVersion() {
        return this.version;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UsernamePasswordCredentials getUsernamePasswordCredentials() {
        return this.credentials;
    }
}

