/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.manager;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.utils.PathUtil;

public class MongoDBConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MongoDBConfiguration.class);
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 27017;
    private static final String DEFAULT_DATABASE = "fucksocks";
    private static final String HOST_KEY = "mongo.host";
    private static final String PORT_KEY = "mongo.port";
    private static final String USERNAME_KEY = "mongo.username";
    private static final String PASSWORD_KEY = "mongo.password";
    private static final String DATABASE_KEY = "mongo.db";
    private String host;
    private int port;
    private String username;
    private String password;
    private String database;

    public MongoDBConfiguration(String host, int port, String database, String username, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
    }

    public static MongoDBConfiguration load(String filePath) {
        try {
            String realPath = PathUtil.getAbstractPath(filePath);
            logger.debug("Load file:{}", (Object)realPath);
            Properties properties = new Properties();
            properties.load(new FileInputStream(realPath));
            String host = properties.getProperty(HOST_KEY, DEFAULT_HOST);
            int port = Integer.parseInt(properties.getProperty(PORT_KEY, "27017"));
            String database = properties.getProperty(DATABASE_KEY, DEFAULT_DATABASE);
            String username = properties.getProperty(USERNAME_KEY);
            String password = properties.getProperty(PASSWORD_KEY);
            return new MongoDBConfiguration(host, port, database, username, password);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getDatabase() {
        return this.database;
    }

    public String toString() {
        return "MongoDBConfiguration{host='" + this.host + '\'' + ", port=" + this.port + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", database='" + this.database + '\'' + '}';
    }
}

