/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.manager;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sockslib.server.manager.User;
import sockslib.server.manager.UserManager;

public class MemoryBasedUserManager
implements UserManager {
    private Map<String, User> users = new HashMap<String, User>();

    @Override
    public void create(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User can't be null");
        }
        if (Strings.isNullOrEmpty((String)user.getPassword())) {
            throw new IllegalArgumentException("username can't be null or empty");
        }
        this.users.put(user.getUsername(), user);
    }

    @Override
    public UserManager addUser(String username, String password) {
        if (Strings.isNullOrEmpty((String)username)) {
            throw new IllegalArgumentException("Username can't be null");
        }
        this.users.put(username, new User(username, password));
        return this;
    }

    @Override
    public User check(String username, String password) {
        User user = this.find(username);
        if (user != null && user.getPassword() != null && user.getPassword().equals(password)) {
            return user;
        }
        return null;
    }

    @Override
    public void delete(String username) {
        this.users.remove(username);
    }

    @Override
    public List<User> findAll() {
        return Lists.newArrayList(this.users.values());
    }

    @Override
    public void update(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User can't null");
        }
        if (Strings.isNullOrEmpty((String)user.getUsername())) {
            throw new IllegalArgumentException("Username of the user can't be null or empty");
        }
        this.users.put(user.getUsername(), user);
    }

    @Override
    public User find(String username) {
        if (Strings.isNullOrEmpty((String)username)) {
            throw new IllegalArgumentException("Username can't be null or empty");
        }
        return this.users.get(username);
    }
}

