/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.manager;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.utils.PathUtil;

public class JdbcConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JdbcConfiguration.class);
    private static final String URL_KEY = "jdbc.url";
    private static final String USERNAME_KEY = "jdbc.username";
    private static final String PASSWORD_KEY = "jdbc.password";
    private String url;
    private String username;
    private String password;

    public JdbcConfiguration(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public static JdbcConfiguration load(String filePath) {
        try {
            String realPath = PathUtil.getAbstractPath(filePath);
            logger.debug("Load file:{}", (Object)realPath);
            Properties properties = new Properties();
            properties.load(new FileInputStream(realPath));
            String url = properties.getProperty(URL_KEY);
            String username = properties.getProperty(USERNAME_KEY);
            String password = properties.getProperty(PASSWORD_KEY);
            return new JdbcConfiguration(url, username, password);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

