/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.manager;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.common.NotImplementException;
import sockslib.server.manager.JdbcConfiguration;
import sockslib.server.manager.NonePasswordProtector;
import sockslib.server.manager.PasswordProtector;
import sockslib.server.manager.User;
import sockslib.server.manager.UserManager;
import sockslib.server.manager.UserRowMapper;
import sockslib.utils.jdbc.JdbcTemplate;
import sockslib.utils.jdbc.RowMapper;

public class JdbcBasedUserManager
implements UserManager {
    public static final String USER_TABLE_NAME = "SOCKS_USERS";
    private static final Logger logger = LoggerFactory.getLogger(JdbcConfiguration.class);
    private static final String CREATE_USER_SQL = "INSERT INTO SOCKS_USERS (`username`,`password`)VALUES(?,?)";
    private static final String QUERY_BY_USERNAME = "SELECT * FROM SOCKS_USERS WHERE `username` = ?";
    private static final String QUERY_ALL_SQL = "SELECT * FROM SOCKS_USERS";
    private static final String UPDATE_USER_SQL = "UPDATE SOCKS_USERS SET `password` = ? WHERE `username`=?";
    private static final String DELETE_USER_SQL = "delete from SOCKS_USERS where `username`=?";
    private String createUserSql = "INSERT INTO SOCKS_USERS (`username`,`password`)VALUES(?,?)";
    private String updateUserSql = "UPDATE SOCKS_USERS SET `password` = ? WHERE `username`=?";
    private String queryAllUserSql = "SELECT * FROM SOCKS_USERS";
    private String queryByUsernameSql = "SELECT * FROM SOCKS_USERS WHERE `username` = ?";
    private String deleteUserSql = "delete from SOCKS_USERS where `username`=?";
    private JdbcTemplate jdbcTemplate;
    private DataSource dataSource;
    private RowMapper<User> rowMapper = new UserRowMapper();
    private PasswordProtector passwordProtector = new NonePasswordProtector();

    public JdbcBasedUserManager() {
    }

    public JdbcBasedUserManager(DataSource dataSource) {
        this.dataSource = (DataSource)Preconditions.checkNotNull((Object)dataSource, (Object)"Argument [dataSource] may not be null");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public void create(User user) {
        user.setPassword(this.generateEncryptPassword(user));
        Object[] args = new Object[]{user.getUsername(), user.getPassword()};
        this.jdbcTemplate.execute(this.createUserSql, args);
    }

    @Override
    public UserManager addUser(String username, String password) {
        this.create(new User(username, password));
        return this;
    }

    @Override
    public User check(String username, String password) {
        User user = this.find(username);
        if (user != null) {
            String encryptPassword = this.generateEncryptPassword(user, password);
            if (user.getPassword().equals(encryptPassword)) {
                return user;
            }
            return null;
        }
        return null;
    }

    @Override
    public void delete(String username) {
        throw new NotImplementException();
    }

    @Override
    public List<User> findAll() {
        return this.jdbcTemplate.query(this.queryAllUserSql, this.rowMapper);
    }

    @Override
    public void update(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User can't null");
        }
        if (Strings.isNullOrEmpty((String)user.getUsername())) {
            throw new IllegalArgumentException("Username of the user can't be null or empty");
        }
        User old = this.find(user.getUsername());
        String newEncryptPassword = this.generateEncryptPassword(user);
        if (!old.getPassword().equals(newEncryptPassword)) {
            user.setPassword(newEncryptPassword);
        }
        Object[] args = new Object[]{user.getPassword(), user.getUsername()};
        this.jdbcTemplate.execute(this.updateUserSql, args);
    }

    @Override
    public User find(String username) {
        Object[] args = new Object[]{username};
        List<User> users = this.jdbcTemplate.query(this.queryByUsernameSql, args, this.rowMapper);
        if (users.size() >= 1) {
            return users.get(0);
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public RowMapper<User> getRowMapper() {
        return this.rowMapper;
    }

    public void setRowMapper(RowMapper<User> rowMapper) {
        this.rowMapper = rowMapper;
    }

    private String generateEncryptPassword(User user, String newPassword) {
        User tempUser = user.copy();
        if (newPassword != null) {
            tempUser.setPassword(newPassword);
        }
        if (this.passwordProtector == null) {
            this.passwordProtector = new NonePasswordProtector();
        }
        return this.passwordProtector.encrypt(tempUser);
    }

    private String generateEncryptPassword(User user) {
        return this.generateEncryptPassword(user, null);
    }

    public PasswordProtector getPasswordProtector() {
        return this.passwordProtector;
    }

    public void setPasswordProtector(PasswordProtector passwordProtector) {
        this.passwordProtector = passwordProtector;
    }

    public String getQueryByUsernameSql() {
        return this.queryByUsernameSql;
    }

    public void setQueryByUsernameSql(String queryByUsernameSql) {
        this.queryByUsernameSql = queryByUsernameSql;
    }

    public String getQueryAllUserSql() {
        return this.queryAllUserSql;
    }

    public void setQueryAllUserSql(String queryAllUserSql) {
        this.queryAllUserSql = queryAllUserSql;
    }

    public String getUpdateUserSql() {
        return this.updateUserSql;
    }

    public void setUpdateUserSql(String updateUserSql) {
        this.updateUserSql = updateUserSql;
    }

    public String getCreateUserSql() {
        return this.createUserSql;
    }

    public void setCreateUserSql(String createUserSql) {
        this.createUserSql = createUserSql;
    }

    public String getDeleteUserSql() {
        return this.deleteUserSql;
    }

    public void setDeleteUserSql(String deleteUserSql) {
        this.deleteUserSql = deleteUserSql;
    }
}

