/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.manager;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.server.manager.PasswordProtector;
import sockslib.server.manager.User;

public class HashPasswordProtector
implements PasswordProtector {
    private static final Logger logger = LoggerFactory.getLogger(HashPasswordProtector.class);
    private HashAlgorithm algorithm = HashAlgorithm.MD5;
    private int hashTime = 1;
    private LoadingCache<String, String> cache;

    public HashPasswordProtector() {
        this(HashAlgorithm.MD5, 1);
    }

    public HashPasswordProtector(HashAlgorithm algorithm) {
        this(algorithm, 1);
    }

    public HashPasswordProtector(HashAlgorithm algorithm, int hashTime) {
        this.algorithm = algorithm;
        this.hashTime = hashTime;
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                return HashPasswordProtector.this.encryptNow(key);
            }
        });
    }

    @Override
    public String encrypt(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User can't be null");
        }
        if (Strings.isNullOrEmpty((String)user.getPassword())) {
            throw new IllegalArgumentException("User's password can't be null or empty");
        }
        return (String)this.cache.getUnchecked((Object)this.getPlainText(user));
    }

    public String getPlainText(User user) {
        return user.getPassword();
    }

    private String encryptNow(String plaintext) {
        logger.debug("Encrypt:{}", (Object)plaintext);
        byte[] bytes = plaintext.getBytes(Charsets.UTF_8);
        for (int i = 0; i < this.hashTime - 1; ++i) {
            Hasher hasher = this.chooseHasher(this.algorithm);
            bytes = hasher.putBytes(bytes).hash().asBytes();
        }
        Hasher hasher = this.chooseHasher(this.algorithm);
        return hasher.putBytes(bytes).hash().toString();
    }

    private Hasher chooseHasher(HashAlgorithm algorithm) {
        Hasher hasher = null;
        switch (algorithm) {
            case MD5: {
                hasher = Hashing.md5().newHasher();
                break;
            }
            case SHA1: {
                hasher = Hashing.sha1().newHasher();
                break;
            }
            case SHA256: {
                hasher = Hashing.sha256().newHasher();
                break;
            }
            case SHA512: {
                hasher = Hashing.sha512().newHasher();
            }
        }
        return hasher;
    }

    public int getHashTime() {
        return this.hashTime;
    }

    public void setHashTime(int hashTime) {
        this.hashTime = hashTime;
    }

    public HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(HashAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public LoadingCache<String, String> getCache() {
        return this.cache;
    }

    public void setCache(LoadingCache<String, String> cache) {
        this.cache = cache;
    }

    public static enum HashAlgorithm {
        MD5,
        SHA1,
        SHA256,
        SHA512;

    }
}

