/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.server.io.Pipe;
import sockslib.server.io.PipeListener;
import sockslib.server.io.StreamPipe;

public class SocketPipe
implements Pipe {
    protected static final Logger logger = LoggerFactory.getLogger(SocketPipe.class);
    public static final String INPUT_PIPE_NAME = "INPUT_PIPE";
    public static final String OUTPUT_PIPE_NAME = "OUTPUT_PIPE";
    public static final String ATTR_SOURCE_SOCKET = "SOURCE_SOCKET";
    public static final String ATTR_DESTINATION_SOCKET = "DESTINATION_SOCKET";
    public static final String ATTR_PARENT_PIPE = "PARENT_PIPE";
    private Pipe pipe1;
    private Pipe pipe2;
    private Socket socket1;
    private Socket socket2;
    private String name;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean running = false;
    private PipeListener listener = new PipeListenerImp();

    public SocketPipe(Socket socket1, Socket socket2) throws IOException {
        this.socket1 = (Socket)Preconditions.checkNotNull((Object)socket1, (Object)"Argument [socks1] may not be null");
        this.socket2 = (Socket)Preconditions.checkNotNull((Object)socket2, (Object)"Argument [socks1] may not be null");
        this.pipe1 = new StreamPipe(socket1.getInputStream(), socket2.getOutputStream(), OUTPUT_PIPE_NAME);
        this.pipe1.setAttribute(ATTR_SOURCE_SOCKET, socket1);
        this.pipe1.setAttribute(ATTR_DESTINATION_SOCKET, socket2);
        this.pipe2 = new StreamPipe(socket2.getInputStream(), socket1.getOutputStream(), INPUT_PIPE_NAME);
        this.pipe2.setAttribute(ATTR_SOURCE_SOCKET, socket2);
        this.pipe2.setAttribute(ATTR_DESTINATION_SOCKET, socket1);
        this.pipe1.addPipeListener(this.listener);
        this.pipe2.addPipeListener(this.listener);
        this.pipe1.setAttribute(ATTR_PARENT_PIPE, this);
        this.pipe2.setAttribute(ATTR_PARENT_PIPE, this);
    }

    @Override
    public boolean start() {
        this.running = this.pipe1.start() && this.pipe2.start();
        return this.running;
    }

    @Override
    public boolean stop() {
        if (this.running) {
            this.pipe1.stop();
            this.pipe2.stop();
            if (!this.pipe1.isRunning() && !this.pipe2.isRunning()) {
                this.running = false;
            }
        }
        return this.running;
    }

    @Override
    public boolean close() {
        this.pipe2.removePipeListener(this.listener);
        this.pipe1.removePipeListener(this.listener);
        this.stop();
        try {
            if (this.socket1 != null && !this.socket1.isClosed()) {
                this.socket1.close();
            }
            if (this.socket2 != null && !this.socket2.isClosed()) {
                this.socket2.close();
            }
            return true;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public int getBufferSize() {
        return 0;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.pipe1.setBufferSize(bufferSize);
        this.pipe2.setBufferSize(bufferSize);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void addPipeListener(PipeListener pipeListener) {
        this.pipe1.addPipeListener(pipeListener);
        this.pipe2.addPipeListener(pipeListener);
    }

    @Override
    public void removePipeListener(PipeListener pipeListener) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    private class PipeListenerImp
    implements PipeListener {
        private PipeListenerImp() {
        }

        @Override
        public void onStop(Pipe pipe) {
            StreamPipe streamPipe = (StreamPipe)pipe;
            logger.trace("Pipe[{}] stopped", (Object)streamPipe.getName());
            SocketPipe.this.close();
        }

        @Override
        public void onStart(Pipe pipe) {
        }

        @Override
        public void onTransfer(Pipe pipe, byte[] buffer, int bufferLength) {
        }

        @Override
        public void onError(Pipe pipe, Exception exception) {
            logger.info("{} {}", (Object)SocketPipe.this.name, (Object)exception.getMessage());
        }
    }
}

