/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.common.Credentials;
import sockslib.common.SocksException;
import sockslib.common.net.MonitorSocketWrapper;
import sockslib.common.net.NetworkMonitor;
import sockslib.server.Session;
import sockslib.server.msg.ReadableMessage;
import sockslib.server.msg.WritableMessage;

public class SocksSession
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(SocksSession.class);
    private Socket socket;
    private long id;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Map<Long, Session> sessions;
    private SocketAddress clientAddress;
    private Map<Object, Object> attributes;
    private NetworkMonitor networkMonitor;
    private Credentials credentials;

    public SocksSession() {
    }

    public SocksSession(Socket socket) {
        this(0L, socket, null);
    }

    public SocksSession(long id, Socket socket, Map<Long, Session> sessions) {
        if (!socket.isConnected()) {
            throw new IllegalArgumentException("Socket should be a connected socket");
        }
        if (socket instanceof MonitorSocketWrapper) {
            this.networkMonitor = new NetworkMonitor();
            ((MonitorSocketWrapper)socket).addMonitor(this.networkMonitor);
        }
        this.id = id;
        this.socket = socket;
        this.sessions = sessions;
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.clientAddress = socket.getRemoteSocketAddress();
        this.attributes = new HashMap<Object, Object>();
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void write(byte[] bytes) throws SocksException, IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(WritableMessage message) throws SocksException, IOException {
        this.write(message.getBytes());
    }

    @Override
    public int read(byte[] bytes) throws SocksException, IOException {
        return this.inputStream.read(bytes);
    }

    @Override
    public int read(ReadableMessage message) throws SocksException, IOException {
        message.read(this.inputStream);
        return message.getLength();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessions.remove(this.id);
        }
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws SocksException, IOException {
        this.outputStream.write(bytes, offset, length);
        this.outputStream.flush();
    }

    @Override
    public Map<Long, Session> getManagedSessions() {
        return this.sessions;
    }

    @Override
    public SocketAddress getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void clearAllAttributes() {
        this.attributes.clear();
    }

    @Override
    public boolean isClose() {
        try {
            this.socket.sendUrgentData(0);
            return false;
        }
        catch (IOException expected) {
            return true;
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public NetworkMonitor getNetworkMonitor() {
        return this.networkMonitor;
    }

    public String toString() {
        return "SESSION[" + this.id + "]@" + this.clientAddress;
    }
}

