/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import java.util.HashSet;
import java.util.Set;
import sockslib.common.methods.NoAcceptableMethod;
import sockslib.common.methods.SocksMethod;
import sockslib.server.MethodSelector;
import sockslib.server.msg.MethodSelectionMessage;

public class SocksMethodSelector
implements MethodSelector {
    private Set<SocksMethod> supportMethods = new HashSet<SocksMethod>();

    @Override
    public SocksMethod select(MethodSelectionMessage message) {
        int[] methods = message.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            for (SocksMethod method : this.supportMethods) {
                if (method.getByte() != methods[i]) continue;
                return method;
            }
        }
        return new NoAcceptableMethod();
    }

    @Override
    public Set<SocksMethod> getSupportMethods() {
        return this.supportMethods;
    }

    @Override
    public void setSupportMethods(Set<SocksMethod> supportMethods) {
        this.supportMethods = supportMethods;
    }

    @Override
    public void removeSupportMethod(SocksMethod socksMethod) {
        this.supportMethods.remove(socksMethod);
    }

    @Override
    public void clearAllSupportMethods() {
        this.supportMethods.clear();
    }

    @Override
    public void addSupportMethod(SocksMethod socksMethod) {
        this.supportMethods.add(socksMethod);
    }

    @Override
    public void setSupportMethod(SocksMethod ... methods) {
        this.supportMethods.clear();
        for (int i = 0; i < methods.length; ++i) {
            this.supportMethods.add(methods[i]);
        }
    }
}

