/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.SocksProxy;
import sockslib.client.SocksSocket;
import sockslib.common.ProtocolErrorException;
import sockslib.common.SocksException;
import sockslib.common.methods.SocksMethod;
import sockslib.server.MethodSelector;
import sockslib.server.Session;
import sockslib.server.SessionManager;
import sockslib.server.SocksHandler;
import sockslib.server.SocksProxyServer;
import sockslib.server.UDPRelayServer;
import sockslib.server.io.Pipe;
import sockslib.server.io.SocketPipe;
import sockslib.server.msg.CommandMessage;
import sockslib.server.msg.CommandResponseMessage;
import sockslib.server.msg.MethodSelectionMessage;
import sockslib.server.msg.MethodSelectionResponseMessage;
import sockslib.server.msg.ServerReply;

public class Socks5Handler
implements SocksHandler {
    protected static final Logger logger = LoggerFactory.getLogger(Socks5Handler.class);
    private static final int VERSION = 5;
    private Session session;
    private MethodSelector methodSelector;
    private int bufferSize;
    private int idleTime = 2000;
    private SocksProxy proxy;
    private SocksProxyServer socksProxyServer;
    private SessionManager sessionManager;

    @Override
    public void handle(Session session) throws Exception {
        this.sessionManager = this.getSocksProxyServer().getSessionManager();
        this.sessionManager.sessionOnCreate(session);
        MethodSelectionMessage msg = new MethodSelectionMessage();
        session.read(msg);
        if (msg.getVersion() != 5) {
            throw new ProtocolErrorException();
        }
        SocksMethod selectedMethod = this.methodSelector.select(msg);
        logger.debug("SESSION[{}] Response client:{}", (Object)session.getId(), (Object)selectedMethod.getMethodName());
        session.write(new MethodSelectionResponseMessage(5, selectedMethod));
        selectedMethod.doMethod(session);
        CommandMessage commandMessage = new CommandMessage();
        session.read(commandMessage);
        if (commandMessage.hasSocksException()) {
            ServerReply serverReply = commandMessage.getSocksException().getServerReply();
            session.write(new CommandResponseMessage(serverReply));
            logger.info("SESSION[{}] will close, because {}", (Object)session.getId(), (Object)serverReply);
            return;
        }
        this.sessionManager.sessionOnCommand(session, commandMessage);
        switch (commandMessage.getCommand()) {
            case BIND: {
                this.doBind(session, commandMessage);
                break;
            }
            case CONNECT: {
                this.doConnect(session, commandMessage);
                break;
            }
            case UDP_ASSOCIATE: {
                this.doUDPAssociate(session, commandMessage);
            }
        }
    }

    @Override
    public void doConnect(Session session, CommandMessage commandMessage) throws SocksException, IOException {
        ServerReply reply = null;
        Socket socket = null;
        InetAddress bindAddress = null;
        int bindPort = 0;
        InetAddress remoteServerAddress = commandMessage.getInetAddress();
        int remoteServerPort = commandMessage.getPort();
        byte[] defaultAddress = new byte[]{0, 0, 0, 0};
        bindAddress = InetAddress.getByAddress(defaultAddress);
        try {
            socket = this.proxy == null ? new Socket(remoteServerAddress, remoteServerPort) : new SocksSocket(this.proxy, remoteServerAddress, remoteServerPort);
            bindAddress = socket.getLocalAddress();
            bindPort = socket.getLocalPort();
            reply = ServerReply.SUCCEEDED;
        }
        catch (IOException e) {
            reply = e.getMessage().equals("Connection refused") ? ServerReply.CONNECTION_REFUSED : (e.getMessage().equals("Operation timed out") ? ServerReply.TTL_EXPIRED : (e.getMessage().equals("Network is unreachable") ? ServerReply.NETWORK_UNREACHABLE : (e.getMessage().equals("Connection timed out") ? ServerReply.TTL_EXPIRED : ServerReply.GENERAL_SOCKS_SERVER_FAILURE)));
            logger.info("SESSION[{}] connect {} [{}] exception:{}", new Object[]{session.getId(), new InetSocketAddress(remoteServerAddress, remoteServerPort), reply, e.getMessage()});
        }
        CommandResponseMessage responseMessage = new CommandResponseMessage(5, reply, bindAddress, bindPort);
        session.write(responseMessage);
        if (reply != ServerReply.SUCCEEDED) {
            session.close();
            return;
        }
        Pipe pipe = new SocketPipe(session.getSocket(), socket);
        pipe.setName("SESSION[" + session.getId() + "]");
        pipe.setBufferSize(this.bufferSize);
        if (this.getSocksProxyServer().getPipeInitializer() != null) {
            pipe = this.getSocksProxyServer().getPipeInitializer().initialize(pipe);
        }
        pipe.start();
        while (pipe.isRunning()) {
            try {
                Thread.sleep(this.idleTime);
            }
            catch (InterruptedException e) {
                pipe.stop();
                session.close();
                logger.info("SESSION[{}] closed", (Object)session.getId());
            }
        }
    }

    @Override
    public void doBind(Session session, CommandMessage commandMessage) throws SocksException, IOException {
        ServerSocket serverSocket = new ServerSocket(commandMessage.getPort());
        int bindPort = serverSocket.getLocalPort();
        Socket socket = null;
        logger.info("Create TCP server bind at {} for session[{}]", (Object)serverSocket.getLocalSocketAddress(), (Object)session.getId());
        session.write(new CommandResponseMessage(5, ServerReply.SUCCEEDED, serverSocket.getInetAddress(), bindPort));
        socket = serverSocket.accept();
        session.write(new CommandResponseMessage(5, ServerReply.SUCCEEDED, socket.getLocalAddress(), socket.getLocalPort()));
        SocketPipe pipe = new SocketPipe(session.getSocket(), socket);
        pipe.setBufferSize(this.bufferSize);
        pipe.start();
        while (pipe.isRunning()) {
            try {
                Thread.sleep(this.idleTime);
            }
            catch (InterruptedException e) {
                pipe.stop();
                session.close();
                logger.info("Session[{}] closed", (Object)session.getId());
            }
        }
        serverSocket.close();
    }

    @Override
    public void doUDPAssociate(Session session, CommandMessage commandMessage) throws SocksException, IOException {
        UDPRelayServer udpRelayServer = new UDPRelayServer(((InetSocketAddress)session.getClientAddress()).getAddress(), commandMessage.getPort());
        InetSocketAddress socketAddress = (InetSocketAddress)udpRelayServer.start();
        logger.info("Create UDP relay server at[{}] for {}", (Object)socketAddress, (Object)commandMessage.getSocketAddress());
        session.write(new CommandResponseMessage(5, ServerReply.SUCCEEDED, InetAddress.getLocalHost(), socketAddress.getPort()));
        while (udpRelayServer.isRunning()) {
            try {
                Thread.sleep(this.idleTime);
            }
            catch (InterruptedException e) {
                session.close();
                logger.info("Session[{}] closed", (Object)session.getId());
            }
            if (!session.isClose()) continue;
            udpRelayServer.stop();
            logger.debug("UDP relay server for session[{}] is closed", (Object)session.getId());
        }
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void run() {
        try {
            this.handle(this.session);
        }
        catch (Exception e) {
            this.sessionManager.sessionOnException(this.session, e);
        }
        finally {
            this.session.close();
            this.sessionManager.sessionOnClose(this.session);
        }
    }

    @Override
    public MethodSelector getMethodSelector() {
        return this.methodSelector;
    }

    @Override
    public void setMethodSelector(MethodSelector methodSelector) {
        this.methodSelector = methodSelector;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getIdleTime() {
        return this.idleTime;
    }

    @Override
    public void setIdleTime(int idleTime) {
        this.idleTime = idleTime;
    }

    public SocksProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(SocksProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public SocksProxyServer getSocksProxyServer() {
        return this.socksProxyServer;
    }

    @Override
    public void setSocksProxyServer(SocksProxyServer socksProxyServer) {
        this.socksProxyServer = socksProxyServer;
    }
}

