/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.SocksProxy;
import sockslib.common.methods.SocksMethod;
import sockslib.common.net.MonitorSocketWrapper;
import sockslib.common.net.NetworkMonitor;
import sockslib.server.BasicSessionManager;
import sockslib.server.MethodSelector;
import sockslib.server.Session;
import sockslib.server.SessionManager;
import sockslib.server.SocksHandler;
import sockslib.server.SocksMethodSelector;
import sockslib.server.SocksProxyServer;
import sockslib.server.listener.PipeInitializer;

public class BasicSocksProxyServer
implements SocksProxyServer,
Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(BasicSocksProxyServer.class);
    protected static final int THREAD_NUMBER = 100;
    private ExecutorService executorService;
    private SessionManager sessionManager = new BasicSessionManager();
    private long nextSessionId = 0L;
    private ServerSocket serverSocket;
    private Class<? extends SocksHandler> socksHandlerClass;
    private Map<Long, Session> sessions;
    private boolean stop = false;
    private Thread thread;
    private int timeout = 10000;
    private boolean daemon = false;
    private MethodSelector methodSelector = new SocksMethodSelector();
    private int bufferSize = 0x500000;
    private int bindPort = 1080;
    private InetAddress bindAddr;
    private SocksProxy proxy;
    private NetworkMonitor networkMonitor = new NetworkMonitor();
    private PipeInitializer pipeInitializer;

    public BasicSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass) {
        this(socketHandlerClass, 1080, Executors.newFixedThreadPool(100));
    }

    public BasicSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass, int port) {
        this(socketHandlerClass, port, Executors.newFixedThreadPool(100));
    }

    public BasicSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass, ExecutorService executorService) {
        this(socketHandlerClass, 1080, executorService);
    }

    public BasicSocksProxyServer(Class<? extends SocksHandler> socketHandlerClass, int port, ExecutorService executorService) {
        this.socksHandlerClass = (Class)Preconditions.checkNotNull(socketHandlerClass, (Object)"Argument [socksHandlerClass] may not be null");
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService, (Object)"Argument [executorService] may not be null");
        this.bindPort = port;
        this.sessions = new HashMap<Long, Session>();
    }

    @Override
    public void run() {
        logger.info("Start proxy server at port:{}", (Object)this.bindPort);
        while (!this.stop) {
            try {
                Socket socket = this.serverSocket.accept();
                socket = this.processSocketBeforeUse(socket);
                socket.setSoTimeout(this.timeout);
                Session session = this.sessionManager.newSession(socket);
                SocksHandler socksHandler = this.createSocksHandler();
                socksHandler.setSession(session);
                this.initializeSocksHandler(socksHandler);
                this.executorService.execute(socksHandler);
            }
            catch (IOException e) {
                if (e.getMessage().equals("Socket closed") && this.stop) {
                    logger.debug("Server shutdown");
                    return;
                }
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        this.stop = true;
        this.executorService.shutdown();
        if (this.thread != null) {
            this.thread.interrupt();
        }
        try {
            this.closeAllSession();
            if (this.serverSocket != null && this.serverSocket.isBound()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void start() throws IOException {
        this.serverSocket = this.createServerSocket(this.bindPort, this.bindAddr);
        this.thread = new Thread(this);
        this.thread.setName("fs-thread");
        this.thread.setDaemon(this.daemon);
        this.thread.start();
    }

    protected ServerSocket createServerSocket(int bindPort, InetAddress bindAddr) throws IOException {
        return new ServerSocket(bindPort, 50, bindAddr);
    }

    @Override
    public SocksHandler createSocksHandler() {
        try {
            return this.socksHandlerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void initializeSocksHandler(SocksHandler socksHandler) {
        socksHandler.setMethodSelector(this.methodSelector);
        socksHandler.setBufferSize(this.bufferSize);
        socksHandler.setProxy(this.proxy);
        socksHandler.setSocksProxyServer(this);
    }

    protected void closeAllSession() {
        for (long key : this.sessions.keySet()) {
            this.sessions.get(key).close();
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    private synchronized long getNextSessionId() {
        ++this.nextSessionId;
        return this.nextSessionId;
    }

    @Override
    public Map<Long, Session> getManagedSessions() {
        return this.sessions;
    }

    @Override
    public void setSupportMethods(SocksMethod ... methods) {
        this.methodSelector.setSupportMethod(methods);
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public SocksProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(SocksProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public InetAddress getBindAddr() {
        return this.bindAddr;
    }

    @Override
    public void setBindAddr(InetAddress bindAddr) {
        this.bindAddr = bindAddr;
    }

    @Override
    public int getBindPort() {
        return this.bindPort;
    }

    @Override
    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    @Override
    public boolean isDaemon() {
        return this.daemon;
    }

    @Override
    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public Thread getServerThread() {
        return this.thread;
    }

    public NetworkMonitor getNetworkMonitor() {
        return this.networkMonitor;
    }

    public void setNetworkMonitor(NetworkMonitor networkMonitor) {
        this.networkMonitor = (NetworkMonitor)Preconditions.checkNotNull((Object)networkMonitor);
    }

    protected Socket processSocketBeforeUse(Socket socket) {
        return new MonitorSocketWrapper(socket, this.networkMonitor);
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public PipeInitializer getPipeInitializer() {
        return this.pipeInitializer;
    }

    @Override
    public void setPipeInitializer(PipeInitializer pipeInitializer) {
        this.pipeInitializer = pipeInitializer;
    }
}

