/*
 * Decompiled with CFR 0.152.
 */
package sockslib.server;

import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import sockslib.server.Session;
import sockslib.server.SessionManager;
import sockslib.server.SocksSession;
import sockslib.server.listener.CloseSessionException;
import sockslib.server.listener.CommandListener;
import sockslib.server.listener.ExceptionListener;
import sockslib.server.listener.SessionCloseListener;
import sockslib.server.listener.SessionCreateListener;
import sockslib.server.listener.SessionListener;
import sockslib.server.msg.CommandMessage;

public class BasicSessionManager
implements SessionManager {
    private static int nextSessionId = 0;
    private Map<Long, Session> managedSessions = new HashMap<Long, Session>();
    private Map<String, SessionCreateListener> sessionCreateListenerMap = new HashMap<String, SessionCreateListener>();
    private Map<String, SessionCloseListener> sessionCloseListenerMap = new HashMap<String, SessionCloseListener>();
    private Map<String, CommandListener> commandListenerMap = new HashMap<String, CommandListener>();
    private Map<String, ExceptionListener> exceptionListenerMap = new HashMap<String, ExceptionListener>();

    @Override
    public Session newSession(Socket socket) {
        SocksSession session = new SocksSession(++nextSessionId, socket, this.managedSessions);
        this.managedSessions.put(session.getId(), session);
        return session;
    }

    @Override
    public Session getSession(long id) {
        return this.managedSessions.get(id);
    }

    @Override
    public void sessionOnCreate(Session session) throws CloseSessionException {
        for (SessionCreateListener listener : this.sessionCreateListenerMap.values()) {
            listener.onCreate(session);
        }
    }

    @Override
    public void sessionOnCommand(Session session, CommandMessage message) throws CloseSessionException {
        for (CommandListener listener : this.commandListenerMap.values()) {
            listener.onCommand(session, message);
        }
    }

    @Override
    public void sessionOnException(Session session, Exception exception) {
        for (ExceptionListener listener : this.exceptionListenerMap.values()) {
            listener.onException(session, exception);
        }
    }

    @Override
    public void sessionOnClose(Session session) {
        for (SessionCloseListener listener : this.sessionCloseListenerMap.values()) {
            listener.onClose(session);
        }
    }

    @Override
    public void removeSessionListener(String name) {
        this.removeCommandListener(name);
        this.removeExceptionListener(name);
        this.removeSessionCloseListener(name);
        this.removeSessionCreateListener(name);
    }

    @Override
    public void addSessionListener(String name, SessionListener listener) {
        this.onCommand(name, listener);
        this.onException(name, listener);
        this.onSessionClose(name, listener);
        this.onSessionCreate(name, listener);
    }

    @Override
    public Map<Long, Session> getManagedSessions() {
        return this.managedSessions;
    }

    @Override
    public SessionManager onSessionClose(String name, SessionCloseListener listener) {
        this.sessionCloseListenerMap.put(name, listener);
        return this;
    }

    @Override
    public SessionManager onSessionCreate(String name, SessionCreateListener listener) {
        this.sessionCreateListenerMap.put(name, listener);
        return this;
    }

    @Override
    public SessionManager onCommand(String name, CommandListener listener) {
        this.commandListenerMap.put(name, listener);
        return this;
    }

    @Override
    public SessionManager onException(String name, ExceptionListener listener) {
        this.exceptionListenerMap.put(name, listener);
        return this;
    }

    public SessionCloseListener removeSessionCloseListener(String name) {
        return this.sessionCloseListenerMap.remove(name);
    }

    public SessionCreateListener removeSessionCreateListener(String name) {
        return this.sessionCreateListenerMap.remove(name);
    }

    public CommandListener removeCommandListener(String name) {
        return this.commandListenerMap.remove(name);
    }

    public ExceptionListener removeExceptionListener(String name) {
        return this.exceptionListenerMap.remove(name);
    }
}

