/*
 * Decompiled with CFR 0.152.
 */
package sockslib.quickstart;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Date;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.utils.Arguments;
import sockslib.utils.Timer;

public class UDPTimeServer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(UDPTimeServer.class);
    private int port = 5050;
    private String[] args;
    private Thread thread;
    private boolean stop = false;

    public static void main(@Nullable String[] args) {
        Timer.open();
        UDPTimeServer server = new UDPTimeServer();
        server.start(args);
    }

    public void start(@Nullable String[] args) {
        this.args = args;
        this.thread = new Thread(this);
        this.thread.setName("udp-time-server-thread");
        this.thread.start();
        this.stop = false;
    }

    public void shutdown() {
        try {
            DatagramSocket clientSocket = new DatagramSocket();
            String shutdownSignal = "shutdown";
            byte[] sendBuffer = shutdownSignal.getBytes();
            DatagramPacket packet = new DatagramPacket(sendBuffer, sendBuffer.length, new InetSocketAddress("localhost", this.port));
            clientSocket.send(packet);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.stop = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public void showHelp() {
        System.out.println("Usage: [Options]");
        System.out.println("    --port=<val>             UDP server Test port");
        System.out.println("    --always-response=<val>  Server always responses <val> to client");
        System.out.println("    -h or --help             Show help");
    }

    public void startInCurrentThread(String[] args) {
        this.args = args;
        this.run();
    }

    @Override
    public void run() {
        String alwaysResponse = null;
        if (this.args != null) {
            for (String arg : this.args) {
                if (arg.equals("-h") || arg.equals("--help")) {
                    this.showHelp();
                    System.exit(0);
                    continue;
                }
                if (arg.startsWith("--port=")) {
                    try {
                        this.port = Arguments.intValueOf(arg);
                    }
                    catch (NumberFormatException e) {
                        logger.error("Value of [--port] should be a number");
                        System.exit(-1);
                    }
                    continue;
                }
                if (arg.startsWith("--always-response=")) {
                    alwaysResponse = Arguments.valueOf(arg);
                    continue;
                }
                logger.error("Unknown argument [{}]", (Object)arg);
                return;
            }
        }
        try {
            logger.info("Starting UDP Time server...");
            DatagramSocket server = new DatagramSocket(this.port);
            logger.info("UDP Time server is created at port [{}]", (Object)server.getLocalPort());
            logger.info("This server will print client request message and response current server time");
            byte[] receiveBuffer = new byte[1024];
            DatagramPacket receivePacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
            while (!this.stop) {
                server.receive(receivePacket);
                String clientMessage = new String(receivePacket.getData(), 0, receivePacket.getLength());
                logger.info("Client[{}] send:[{}]", (Object)receivePacket.getSocketAddress(), (Object)clientMessage);
                if (clientMessage.equals("shutdown")) break;
                String responseMsg = new Date().toString();
                if (alwaysResponse != null) {
                    responseMsg = alwaysResponse;
                }
                byte[] data = responseMsg.getBytes();
                DatagramPacket packet = new DatagramPacket(data, data.length, receivePacket.getAddress(), receivePacket.getPort());
                server.send(packet);
            }
            server.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("UDP time server shutdown");
    }
}

