/*
 * Decompiled with CFR 0.152.
 */
package sockslib.quickstart;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.Socks5;
import sockslib.client.Socks5DatagramSocket;
import sockslib.common.UsernamePasswordCredentials;
import sockslib.common.net.MonitorDatagramSocketWrapper;
import sockslib.common.net.NetworkMonitor;
import sockslib.utils.Arguments;
import sockslib.utils.ResourceUtil;
import sockslib.utils.Timer;

public class UDPTimeClient {
    private static final Logger logger = LoggerFactory.getLogger(UDPTimeClient.class);

    public static void main(String[] args) {
        Timer.open();
        new UDPTimeClient().start(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Nullable String[] args) {
        String host = "localhost";
        int port = 5050;
        String proxyHost = null;
        int proxyPort = 1080;
        boolean useProxy = false;
        String username = null;
        String password = null;
        String message = "Hi, I am UDP client";
        if (args != null) {
            for (String arg : args) {
                if (arg.equals("-h") || arg.equals("--help")) {
                    this.showHelp();
                    System.exit(0);
                    continue;
                }
                if (arg.startsWith("--proxy-host=")) {
                    proxyHost = Arguments.valueOf(arg);
                    useProxy = true;
                    continue;
                }
                if (arg.startsWith("--proxy-port=")) {
                    proxyPort = Arguments.intValueOf(arg);
                    continue;
                }
                if (arg.startsWith("--proxy-user=")) {
                    username = Arguments.valueOf(arg);
                    continue;
                }
                if (arg.startsWith("--proxy-password=")) {
                    password = Arguments.valueOf(arg);
                    continue;
                }
                if (arg.startsWith("--host=")) {
                    host = Arguments.valueOf(arg);
                    continue;
                }
                if (arg.startsWith("--port=")) {
                    port = Arguments.intValueOf(arg);
                    continue;
                }
                if (arg.startsWith("--message=")) {
                    message = Arguments.valueOf(arg);
                    continue;
                }
                logger.error("Unknown argument [{}]", (Object)arg);
                System.exit(-1);
            }
        }
        if (useProxy && proxyHost == null) {
            logger.error("Please use [--proxy-host] to set proxy server's hostname if you want to use SOCKS proxy");
            System.exit(-1);
        }
        DatagramSocket clientSocket = null;
        try {
            NetworkMonitor networkMonitor = new NetworkMonitor();
            if (useProxy) {
                Socks5 proxy = new Socks5(new InetSocketAddress(proxyHost, proxyPort));
                if (username != null && password != null) {
                    proxy.setCredentials(new UsernamePasswordCredentials(username, password));
                }
                logger.info("Connect server [{}:{}] by proxy:{}", new Object[]{host, port, proxy});
                clientSocket = new Socks5DatagramSocket(proxy);
            } else {
                logger.info("Connect server [{}:{}]", (Object)host, (Object)port);
                clientSocket = new DatagramSocket();
            }
            clientSocket = new MonitorDatagramSocketWrapper(clientSocket, networkMonitor);
            byte[] sendBuffer = message.getBytes();
            DatagramPacket packet = new DatagramPacket(sendBuffer, sendBuffer.length, new InetSocketAddress(host, port));
            clientSocket.send(packet);
            byte[] receiveBuf = new byte[100];
            DatagramPacket receivedPacket = new DatagramPacket(receiveBuf, receiveBuf.length);
            clientSocket.receive(receivedPacket);
            String receiveStr = new String(receivedPacket.getData(), 0, receivedPacket.getLength());
            logger.info("Server response:{}", (Object)receiveStr);
            logger.info("Total Sent:{}, Total Received:{}, Total:{}", new Object[]{networkMonitor.getTotalSend(), networkMonitor.getTotalReceive(), networkMonitor.getTotal()});
            ResourceUtil.close(clientSocket);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ResourceUtil.close(clientSocket);
        }
    }

    public void showHelp() {
        System.out.println("Usage: [Options]");
        System.out.println("    --host=<val>            UDP time server host, default \"localhost\"");
        System.out.println("    --port=<val>            UDP time server port, default \"5050\"");
        System.out.println("    --proxy-host=<val>      Host of SOCKS5 proxy server");
        System.out.println("    --proxy-port=<val>      Port of SOCKS5 proxy server, default \"1080\"");
        System.out.println("    --proxy-user=<val>      Username of SOCKS5 proxy server");
        System.out.println("    --proxy-password=<val>  Password of SOCKS5 proxy server");
        System.out.println("    --message=<val>         The message which will send to server");
        System.out.println("    -h or --help            Show help");
    }
}

