/*
 * Decompiled with CFR 0.152.
 */
package sockslib.quickstart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.Socks5;
import sockslib.client.SocksProxy;
import sockslib.client.SocksSocket;
import sockslib.common.UsernamePasswordCredentials;
import sockslib.common.net.MonitorSocketWrapper;
import sockslib.common.net.NetworkMonitor;
import sockslib.utils.Arguments;
import sockslib.utils.Timer;

public class TCPTimeClient {
    private static final Logger logger = LoggerFactory.getLogger(TCPTimeClient.class);

    public static void main(@Nullable String[] args) {
        new TCPTimeClient().start(args);
    }

    public void start(@Nullable String[] args) {
        Timer.open();
        String host = "localhost";
        int port = 5051;
        String proxyHost = null;
        int proxyPort = 1080;
        boolean useProxy = false;
        String username = null;
        String password = null;
        String message = "Hi, I am UDP client";
        if (args != null) {
            for (String arg : args) {
                if (arg.equals("-h") || arg.equals("--help")) {
                    this.showHelp();
                    System.exit(0);
                    continue;
                }
                if (arg.startsWith("--proxy-host=")) {
                    proxyHost = Arguments.valueOf(arg);
                    useProxy = true;
                    continue;
                }
                if (arg.startsWith("--proxy-port=")) {
                    proxyPort = Arguments.intValueOf(arg);
                    continue;
                }
                if (arg.startsWith("--proxy-user=")) {
                    username = Arguments.valueOf(arg);
                    continue;
                }
                if (arg.startsWith("--proxy-password=")) {
                    password = Arguments.valueOf(arg);
                    continue;
                }
                if (arg.startsWith("--host=")) {
                    host = Arguments.valueOf(arg);
                    continue;
                }
                if (arg.startsWith("--port=")) {
                    port = Arguments.intValueOf(arg);
                    continue;
                }
                if (arg.startsWith("--message=")) {
                    message = Arguments.valueOf(arg);
                    continue;
                }
                logger.error("Unknown argument [{}]", (Object)arg);
                System.exit(-1);
            }
        }
        if (useProxy && proxyHost == null) {
            logger.error("Please use [--proxy-host] to set proxy server's hostname if you want to use SOCKS proxy");
            System.exit(-1);
        }
        try {
            Socket socket = null;
            if (useProxy) {
                Socks5 proxy = new Socks5(new InetSocketAddress(proxyHost, proxyPort));
                if (username != null && password != null) {
                    proxy.setCredentials(new UsernamePasswordCredentials(username, password));
                }
                logger.info("Connect server [{}:{}] by proxy:{}", new Object[]{host, port, proxy});
                socket = new SocksSocket((SocksProxy)proxy, host, port);
            } else {
                socket = new Socket(host, port);
            }
            NetworkMonitor monitor = new NetworkMonitor();
            socket = new MonitorSocketWrapper(socket, monitor);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            String sendMessage = "Hi, I am TCP time client";
            if (message != null) {
                sendMessage = message;
            }
            sendMessage = sendMessage + "\n";
            outputStream.write(sendMessage.getBytes());
            outputStream.flush();
            byte[] buffer = new byte[5225];
            int length = inputStream.read(buffer);
            String receiveMessage = new String(buffer, 0, length);
            logger.info("Server response:{}", (Object)receiveMessage);
            inputStream.close();
            outputStream.close();
            socket.close();
            logger.info("Total send:{}, Total receive:{}, Total:{}", new Object[]{monitor.getTotalSend(), monitor.getTotalReceive(), monitor.getTotal()});
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void showHelp() {
        String a = "1";
        System.out.println("Usage: [Options]");
        System.out.println("    --host=<val>            TCP time server host, default \"localhost\"");
        System.out.println("    --port=<val>            TCP time server port, default \"5051\"");
        System.out.println("    --proxy-host=<val>      Host of SOCKS5 proxy server");
        System.out.println("    --proxy-port=<val>      Port of SOCKS5 proxy server, default \"1080\"");
        System.out.println("    --proxy-user=<val>      Username of SOCKS5 proxy server");
        System.out.println("    --proxy-password=<val>  Password of SOCKS5 proxy server");
        System.out.println("    --message=<val>         The message which will send to server");
        System.out.println("    -h or --help            Show help");
    }
}

