/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common.net;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sockslib.common.net.InputStreamMonitor;
import sockslib.common.net.MonitorInputStreamWrapper;
import sockslib.common.net.MonitorOutputStreamWrapper;
import sockslib.common.net.OutputStreamMonitor;
import sockslib.common.net.SocketMonitor;

public class MonitorSocketWrapper
extends Socket {
    private Socket originalSocket;
    private List<SocketMonitor> monitors;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;

    public MonitorSocketWrapper(Socket socket, SocketMonitor ... monitors) {
        this.originalSocket = (Socket)Preconditions.checkNotNull((Object)socket, (Object)"Argument [socket] may not be null");
        this.monitors = new ArrayList<SocketMonitor>(monitors.length);
        Collections.addAll(this.monitors, monitors);
    }

    public MonitorSocketWrapper(Socket socket, List<SocketMonitor> monitors) {
        this.originalSocket = (Socket)Preconditions.checkNotNull((Object)socket, (Object)"Argument [socket] may not be null");
        this.monitors = (List)Preconditions.checkNotNull(monitors, (Object)"Arugment [monitors] may not be null");
    }

    public MonitorSocketWrapper(Socket socket) {
        this.originalSocket = (Socket)Preconditions.checkNotNull((Object)socket, (Object)"Argument [socket] may not be null");
    }

    public static Socket wrap(Socket socket, SocketMonitor ... monitors) {
        return new MonitorSocketWrapper(socket, monitors);
    }

    public static Socket wrap(Socket socket, List<SocketMonitor> monitors) {
        return new MonitorSocketWrapper(socket, monitors);
    }

    public MonitorSocketWrapper addMonitor(SocketMonitor monitor) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<SocketMonitor>(1);
        }
        this.monitors.add(monitor);
        return this;
    }

    public MonitorSocketWrapper removeMonitor(SocketMonitor monitor) {
        if (this.monitors != null) {
            this.monitors.remove(monitor);
        }
        return this;
    }

    public Socket getOriginalSocket() {
        return this.originalSocket;
    }

    public void setOriginalSocket(Socket originalSocket) {
        this.originalSocket = originalSocket;
    }

    public List<SocketMonitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<SocketMonitor> monitors) {
        this.monitors = monitors;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.originalSocket.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.originalSocket.connect(endpoint, timeout);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.originalSocket.bind(bindpoint);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.originalSocket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.originalSocket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.originalSocket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.originalSocket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.originalSocket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.originalSocket.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.originalSocket.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = this.getInputStreamFromSocket();
        }
        return this.inputStream;
    }

    public InputStream getInputStreamFromSocket() throws IOException {
        ArrayList<InputStreamMonitor> inputStreamMonitors = new ArrayList<InputStreamMonitor>(this.monitors.size());
        if (this.monitors != null) {
            for (SocketMonitor socketMonitor : this.monitors) {
                inputStreamMonitors.add(socketMonitor);
            }
        }
        return MonitorInputStreamWrapper.wrap(this.originalSocket.getInputStream(), inputStreamMonitors);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = this.getOutputStreamFromSocket();
        }
        return this.outputStream;
    }

    public OutputStream getOutputStreamFromSocket() throws IOException {
        ArrayList<OutputStreamMonitor> outputStreamMonitors = new ArrayList<OutputStreamMonitor>(this.monitors.size());
        if (this.monitors != null) {
            for (SocketMonitor socketMonitor : this.monitors) {
                outputStreamMonitors.add(socketMonitor);
            }
        }
        return MonitorOutputStreamWrapper.wrap(this.originalSocket.getOutputStream(), outputStreamMonitors);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.originalSocket.getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.originalSocket.setTcpNoDelay(on);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.originalSocket.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.originalSocket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.originalSocket.sendUrgentData(data);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.originalSocket.getOOBInline();
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.originalSocket.setOOBInline(on);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.originalSocket.getSoTimeout();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.originalSocket.setSoTimeout(timeout);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.originalSocket.getSendBufferSize();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.originalSocket.setSendBufferSize(size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.originalSocket.getReceiveBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.originalSocket.setReceiveBufferSize(size);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.originalSocket.getKeepAlive();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.originalSocket.setKeepAlive(on);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.originalSocket.getTrafficClass();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.originalSocket.setTrafficClass(tc);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.originalSocket.getReuseAddress();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.originalSocket.setReuseAddress(on);
    }

    @Override
    public synchronized void close() throws IOException {
        this.originalSocket.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.originalSocket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.originalSocket.shutdownOutput();
    }

    @Override
    public String toString() {
        return this.originalSocket.toString();
    }

    @Override
    public boolean isConnected() {
        return this.originalSocket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.originalSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.originalSocket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.originalSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.originalSocket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.originalSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    public int hashCode() {
        return this.originalSocket.hashCode();
    }

    public boolean equals(Object obj) {
        return this.originalSocket.equals(obj);
    }
}

