/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common.net;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sockslib.common.net.OutputStreamMonitor;

public class MonitorOutputStreamWrapper
extends OutputStream {
    private OutputStream originalOutputStream;
    private List<OutputStreamMonitor> monitors;

    public MonitorOutputStreamWrapper(OutputStream outputStream, OutputStreamMonitor ... monitors) {
        this.originalOutputStream = outputStream;
        this.monitors = new ArrayList<OutputStreamMonitor>(monitors.length);
        Collections.addAll(this.monitors, monitors);
    }

    public MonitorOutputStreamWrapper(OutputStream outputStream, List<OutputStreamMonitor> monitors) {
        this.originalOutputStream = (OutputStream)Preconditions.checkNotNull((Object)outputStream);
        this.monitors = (List)Preconditions.checkNotNull(monitors);
    }

    public static OutputStream wrap(OutputStream outputStream, OutputStreamMonitor ... monitors) {
        return new MonitorOutputStreamWrapper(outputStream, monitors);
    }

    public static OutputStream wrap(OutputStream outputStream, List<OutputStreamMonitor> monitors) {
        return new MonitorOutputStreamWrapper(outputStream, monitors);
    }

    public MonitorOutputStreamWrapper addMonitor(OutputStreamMonitor monitor) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<OutputStreamMonitor>(1);
        }
        this.monitors.add((OutputStreamMonitor)Preconditions.checkNotNull((Object)monitor));
        return this;
    }

    public MonitorOutputStreamWrapper removeMonitor(OutputStreamMonitor monitor) {
        if (this.monitors != null) {
            this.monitors.remove(monitor);
        }
        return this;
    }

    public OutputStream getOriginalOutputStream() {
        return this.originalOutputStream;
    }

    public void setOriginalOutputStream(OutputStream originalOutputStream) {
        this.originalOutputStream = (OutputStream)Preconditions.checkNotNull((Object)originalOutputStream);
    }

    @Override
    public void write(int b) throws IOException {
        this.originalOutputStream.write(b);
        byte[] bytes = new byte[]{(byte)b};
        this.informMonitor(bytes);
    }

    public List<OutputStreamMonitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<OutputStreamMonitor> monitors) {
        this.monitors = monitors;
    }

    @Override
    public void close() throws IOException {
        this.originalOutputStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.originalOutputStream.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.originalOutputStream.write(b, off, len);
        this.informMonitor(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.originalOutputStream.write(b);
        this.informMonitor(b);
    }

    private void informMonitor(byte[] bytes) {
        if (this.monitors != null) {
            for (OutputStreamMonitor monitor : this.monitors) {
                monitor.onWrite(bytes);
            }
        }
    }

    private void informMonitor(byte[] bytes, int off, int length) {
        if (this.monitors != null) {
            for (OutputStreamMonitor monitor : this.monitors) {
                monitor.onWrite(Arrays.copyOfRange(bytes, off, off + length));
            }
        }
    }
}

