/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sockslib.common.net.DatagramSocketMonitor;

public class MonitorDatagramSocketWrapper
extends DatagramSocket {
    private List<DatagramSocketMonitor> monitors;
    private DatagramSocket originalDatagramSocket;

    public MonitorDatagramSocketWrapper() throws SocketException {
    }

    public MonitorDatagramSocketWrapper(DatagramSocket datagramSocket) throws SocketException {
        this.originalDatagramSocket = datagramSocket;
    }

    public MonitorDatagramSocketWrapper(DatagramSocket datagramSocket, DatagramSocketMonitor ... monitors) throws SocketException {
        this.originalDatagramSocket = datagramSocket;
        this.monitors = new ArrayList<DatagramSocketMonitor>(monitors.length);
        Collections.addAll(this.monitors, monitors);
    }

    public static void main(String[] args) throws SocketException {
        new MonitorDatagramSocketWrapper();
    }

    public DatagramSocket getOriginalDatagramSocket() {
        return this.originalDatagramSocket;
    }

    public void setOriginalDatagramSocket(DatagramSocket originalDatagramSocket) {
        this.originalDatagramSocket = originalDatagramSocket;
    }

    public List<DatagramSocketMonitor> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<DatagramSocketMonitor> monitors) {
        this.monitors = monitors;
    }

    @Override
    public void send(DatagramPacket p) throws IOException {
        this.originalDatagramSocket.send(p);
        if (this.monitors != null) {
            for (DatagramSocketMonitor monitor : this.monitors) {
                monitor.onSend(p);
            }
        }
    }

    @Override
    public synchronized void receive(DatagramPacket p) throws IOException {
        this.originalDatagramSocket.receive(p);
        if (this.monitors != null) {
            for (DatagramSocketMonitor monitor : this.monitors) {
                monitor.onReceive(p);
            }
        }
    }

    @Override
    public synchronized void bind(SocketAddress addr) throws SocketException {
    }

    @Override
    public void connect(InetAddress address, int port) {
        this.originalDatagramSocket.connect(address, port);
    }

    @Override
    public boolean isBound() {
        return this.originalDatagramSocket.isBound();
    }

    @Override
    public void connect(SocketAddress addr) throws SocketException {
        this.originalDatagramSocket.connect(addr);
    }

    @Override
    public void disconnect() {
        this.originalDatagramSocket.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.originalDatagramSocket.isConnected();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.originalDatagramSocket.getInetAddress();
    }

    @Override
    public int getPort() {
        return this.originalDatagramSocket.getPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.originalDatagramSocket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.originalDatagramSocket.getRemoteSocketAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.originalDatagramSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.originalDatagramSocket.getLocalPort();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.originalDatagramSocket.getSoTimeout();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.originalDatagramSocket.setSoTimeout(timeout);
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.originalDatagramSocket.getSendBufferSize();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.originalDatagramSocket.setSendBufferSize(size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.originalDatagramSocket.getReceiveBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.originalDatagramSocket.setReceiveBufferSize(size);
    }

    @Override
    public synchronized boolean getReuseAddress() throws SocketException {
        return this.originalDatagramSocket.getReuseAddress();
    }

    @Override
    public synchronized void setReuseAddress(boolean on) throws SocketException {
        this.originalDatagramSocket.setReuseAddress(on);
    }

    @Override
    public synchronized boolean getBroadcast() throws SocketException {
        return this.originalDatagramSocket.getBroadcast();
    }

    @Override
    public synchronized void setBroadcast(boolean on) throws SocketException {
        this.originalDatagramSocket.setBroadcast(on);
    }

    @Override
    public synchronized int getTrafficClass() throws SocketException {
        return this.originalDatagramSocket.getTrafficClass();
    }

    @Override
    public synchronized void setTrafficClass(int tc) throws SocketException {
        this.originalDatagramSocket.setTrafficClass(tc);
    }

    @Override
    public void close() {
        this.originalDatagramSocket.close();
    }

    @Override
    public boolean isClosed() {
        return this.originalDatagramSocket.isClosed();
    }

    @Override
    public DatagramChannel getChannel() {
        return this.originalDatagramSocket.getChannel();
    }
}

