/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common.methods;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.client.SocksProxy;
import sockslib.common.AuthenticationException;
import sockslib.common.Credentials;
import sockslib.common.SocksException;
import sockslib.common.UsernamePasswordCredentials;
import sockslib.common.methods.AbstractSocksMethod;
import sockslib.server.Session;
import sockslib.server.UsernamePasswordAuthenticator;
import sockslib.server.msg.UsernamePasswordMessage;
import sockslib.server.msg.UsernamePasswordResponseMessage;
import sockslib.utils.LogMessageBuilder;

public class UsernamePasswordMethod
extends AbstractSocksMethod {
    private static final Logger logger = LoggerFactory.getLogger(UsernamePasswordMethod.class);
    private UsernamePasswordAuthenticator authenticator = new UsernamePasswordAuthenticator();

    public UsernamePasswordMethod() {
    }

    public UsernamePasswordMethod(UsernamePasswordAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public final int getByte() {
        return 2;
    }

    @Override
    public void doMethod(SocksProxy socksProxy) throws SocksException, IOException {
        Preconditions.checkNotNull((Object)socksProxy, (Object)"Argument [socksProxy] may not be null");
        Credentials credentials = socksProxy.getCredentials();
        if (credentials == null || !(credentials instanceof UsernamePasswordCredentials)) {
            throw new SocksException("Need Username/Password authentication");
        }
        String username = credentials.getUserPrincipal().getName();
        String password = credentials.getPassword();
        InputStream inputStream = socksProxy.getInputStream();
        OutputStream outputStream = socksProxy.getOutputStream();
        int USERNAME_LENGTH = username.getBytes().length;
        int PASSWORD_LENGTH = password.getBytes().length;
        byte[] bytesOfUsername = username.getBytes();
        byte[] bytesOfPassword = password.getBytes();
        byte[] bufferSent = new byte[3 + USERNAME_LENGTH + PASSWORD_LENGTH];
        bufferSent[0] = 1;
        bufferSent[1] = (byte)USERNAME_LENGTH;
        System.arraycopy(bytesOfUsername, 0, bufferSent, 2, USERNAME_LENGTH);
        bufferSent[2 + USERNAME_LENGTH] = (byte)PASSWORD_LENGTH;
        System.arraycopy(bytesOfPassword, 0, bufferSent, 3 + USERNAME_LENGTH, PASSWORD_LENGTH);
        outputStream.write(bufferSent);
        outputStream.flush();
        logger.debug("{}", (Object)LogMessageBuilder.build(bufferSent, LogMessageBuilder.MsgType.SEND));
        byte[] authenticationResult = new byte[2];
        inputStream.read(authenticationResult);
        logger.debug("{}", (Object)LogMessageBuilder.build(authenticationResult, LogMessageBuilder.MsgType.RECEIVE));
        if (authenticationResult[1] != 0) {
            outputStream.close();
            inputStream.close();
            socksProxy.getProxySocket().close();
            throw new AuthenticationException("Username or password error");
        }
    }

    @Override
    public void doMethod(Session session) throws SocksException, IOException {
        Preconditions.checkNotNull((Object)session, (Object)"Argument [session] may not be null");
        Preconditions.checkNotNull((Object)this.authenticator, (Object)"Please set an authenticator");
        UsernamePasswordMessage usernamePasswordMessage = new UsernamePasswordMessage();
        session.read(usernamePasswordMessage);
        logger.debug("SESSION[{}] Receive credentials: {}", (Object)session.getId(), (Object)usernamePasswordMessage.getUsernamePasswordCredentials());
        try {
            this.authenticator.doAuthenticate(usernamePasswordMessage.getUsernamePasswordCredentials(), session);
        }
        catch (AuthenticationException e) {
            session.write(new UsernamePasswordResponseMessage(false));
            throw e;
        }
        session.write(new UsernamePasswordResponseMessage(true));
    }

    @Override
    public String getMethodName() {
        return "USERNAME/PASSWORD authentication";
    }

    public UsernamePasswordAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(UsernamePasswordAuthenticator authenticator) {
        this.authenticator = authenticator;
    }
}

