/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import java.io.IOException;
import sockslib.server.msg.ServerReply;

public class SocksException
extends IOException {
    private static final long serialVersionUID = 1L;
    private static final String NO_ACCEPTABLE_METHODS = "NO ACCEPTABLE METHODS";
    private static final String[] serverReplyMessage = new String[]{"General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
    private ServerReply serverReply;

    public SocksException(String msg) {
        super(msg);
    }

    public SocksException(int replyCode) {
    }

    public static SocksException noAcceptableMethods() {
        return new SocksException(NO_ACCEPTABLE_METHODS);
    }

    public static SocksException protocolNotSupported() {
        return new SocksException("Protocol not supported");
    }

    public static SocksException serverReplyException(ServerReply reply) {
        SocksException ex = SocksException.serverReplyException(reply.getValue());
        ex.setServerReply(reply);
        return ex;
    }

    public static SocksException serverReplyException(byte reply) {
        int code = reply;
        if ((code &= 0xFF) < 0 || code > 8) {
            return new SocksException("Unknown reply");
        }
        return new SocksException(serverReplyMessage[--code]);
    }

    public ServerReply getServerReply() {
        return this.serverReply;
    }

    public void setServerReply(ServerReply serverReply) {
        this.serverReply = serverReply;
    }
}

