/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sockslib.common.DatagramPacketDecapsulation;
import sockslib.common.DatagramPacketEncapsulation;
import sockslib.common.SocksException;
import sockslib.utils.SocksUtil;

public class Socks5DatagramPacketHandler
implements DatagramPacketEncapsulation,
DatagramPacketDecapsulation {
    protected static final Logger logger = LoggerFactory.getLogger(Socks5DatagramPacketHandler.class);

    @Override
    public DatagramPacket encapsulate(DatagramPacket packet, SocketAddress destination) throws SocksException {
        if (destination instanceof InetSocketAddress) {
            InetSocketAddress destinationAddress = (InetSocketAddress)destination;
            byte[] data = packet.getData();
            InetAddress remoteServerAddress = packet.getAddress();
            byte[] addressBytes = remoteServerAddress.getAddress();
            int ADDRESS_LENGTH = remoteServerAddress.getAddress().length;
            int remoteServerPort = packet.getPort();
            byte[] buffer = new byte[6 + packet.getLength() + ADDRESS_LENGTH];
            buffer[1] = 0;
            buffer[0] = 0;
            buffer[2] = 0;
            buffer[3] = (byte)(ADDRESS_LENGTH == 4 ? 1 : 4);
            System.arraycopy(addressBytes, 0, buffer, 4, ADDRESS_LENGTH);
            buffer[4 + ADDRESS_LENGTH] = SocksUtil.getFirstByteFromInt(remoteServerPort);
            buffer[5 + ADDRESS_LENGTH] = SocksUtil.getSecondByteFromInt(remoteServerPort);
            System.arraycopy(data, 0, buffer, 6 + ADDRESS_LENGTH, packet.getLength());
            return new DatagramPacket(buffer, buffer.length, destinationAddress.getAddress(), destinationAddress.getPort());
        }
        throw new IllegalArgumentException("Only support java.net.InetSocketAddress");
    }

    @Override
    public void decapsulate(DatagramPacket packet) throws SocksException {
        byte[] data = packet.getData();
        if (data[0] != 0 || data[1] != data[0]) {
            throw new SocksException("SOCKS version error");
        }
        if (data[2] != 0) {
            throw new SocksException("SOCKS fregment is not supported");
        }
        InetAddress remoteServerAddress = null;
        int remoteServerPort = -1;
        byte[] originalData = null;
        switch (data[3]) {
            case 1: {
                try {
                    remoteServerAddress = InetAddress.getByAddress(Arrays.copyOfRange(data, 4, 8));
                }
                catch (UnknownHostException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                remoteServerPort = SocksUtil.bytesToInt(data[8], data[9]);
                originalData = Arrays.copyOfRange(data, 10, packet.getLength());
                break;
            }
            case 4: {
                try {
                    remoteServerAddress = InetAddress.getByAddress(Arrays.copyOfRange(data, 4, 20));
                }
                catch (UnknownHostException e) {
                    throw new SocksException("Unknown host");
                }
                remoteServerPort = SocksUtil.bytesToInt(data[20], data[21]);
                originalData = Arrays.copyOfRange(data, 22, packet.getLength());
                break;
            }
            case 3: {
                byte DOMAIN_LENGTH = data[4];
                String domainName = new String(data, 5, (int)DOMAIN_LENGTH);
                try {
                    remoteServerAddress = InetAddress.getByName(domainName);
                }
                catch (UnknownHostException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                remoteServerPort = SocksUtil.bytesToInt(data[5 + DOMAIN_LENGTH], data[6 + DOMAIN_LENGTH]);
                originalData = Arrays.copyOfRange(data, 7 + DOMAIN_LENGTH, packet.getLength());
                break;
            }
        }
        packet.setAddress(remoteServerAddress);
        packet.setPort(remoteServerPort);
        packet.setData(originalData);
    }
}

