/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import com.google.common.base.Preconditions;
import sockslib.common.KeyStoreInfo;
import sockslib.common.SSLConfiguration;

public class SSLConfigurationBuilder {
    private String keyStorePath;
    private String keyStorePassword;
    private String trustKeyStorePath;
    private String trustKeyStorePassword;
    private boolean clientAuth = false;
    private String keyStoreType = "JKS";
    private String trustKeyStoreType = "JKS";

    private SSLConfigurationBuilder() {
    }

    public static SSLConfigurationBuilder newBuilder() {
        return new SSLConfigurationBuilder();
    }

    public SSLConfigurationBuilder setKeyStorePath(String keyStorePath) {
        this.keyStorePath = (String)Preconditions.checkNotNull((Object)keyStorePath);
        return this;
    }

    public SSLConfigurationBuilder setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = (String)Preconditions.checkNotNull((Object)keyStorePassword);
        return this;
    }

    public SSLConfigurationBuilder setTrustKeyStorePath(String trustKeyStorePath) {
        this.trustKeyStorePath = (String)Preconditions.checkNotNull((Object)trustKeyStorePath);
        return this;
    }

    public SSLConfigurationBuilder setTrustKeyStorePassword(String trustKeyStorePassword) {
        this.trustKeyStorePassword = (String)Preconditions.checkNotNull((Object)trustKeyStorePassword);
        return this;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public SSLConfigurationBuilder setKeyStoreType(String keyStoreType) {
        this.keyStoreType = (String)Preconditions.checkNotNull((Object)keyStoreType);
        return this;
    }

    public SSLConfigurationBuilder useKeystoreAsTrustKeyStore() {
        this.trustKeyStorePath = this.keyStorePath;
        this.trustKeyStorePassword = this.keyStorePassword;
        this.trustKeyStoreType = this.keyStoreType;
        return this;
    }

    public SSLConfigurationBuilder useTrustKeyStoreAsKeyStore() {
        this.keyStorePath = this.trustKeyStorePath;
        this.keyStorePassword = this.trustKeyStorePassword;
        this.keyStoreType = this.trustKeyStoreType;
        return this;
    }

    public SSLConfigurationBuilder setTrustKeyStoreType(String trustKeyStoreType) {
        this.trustKeyStoreType = (String)Preconditions.checkNotNull((Object)trustKeyStoreType);
        return this;
    }

    public SSLConfiguration build() {
        KeyStoreInfo keyStore = null;
        if (this.keyStorePath != null) {
            keyStore = new KeyStoreInfo(this.keyStorePath, this.keyStorePassword, this.keyStoreType);
        }
        KeyStoreInfo trustKeyStore = null;
        if (this.trustKeyStorePath != null) {
            trustKeyStore = new KeyStoreInfo(this.trustKeyStorePath, this.trustKeyStorePassword, this.trustKeyStoreType);
        }
        return new SSLConfiguration(keyStore, trustKeyStore, this.clientAuth);
    }
}

