/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sockslib.common.IP;
import sockslib.common.IPIterator;

public class IPRange
implements Iterable<IP>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IP startIP;
    private final IP endIP;

    public IPRange(IP startIp, IP endIp) {
        int result = endIp.compareTo(startIp);
        if (result > 0 || result == 0) {
            Preconditions.checkArgument((result > 0 || result == 0 ? 1 : 0) != 0, (Object)"maxIP must equal or bigger than minIP");
        }
        this.startIP = startIp;
        this.endIP = endIp;
    }

    public static IPRange parse(String range) {
        String[] ips = range.split("-");
        Preconditions.checkArgument((ips.length == 2 ? 1 : 0) != 0, (Object)("IP range string must be fomarted as [minIP-maxIP],error argument:" + range));
        return new IPRange(IP.parseFromString(ips[0]), IP.parseFromString(ips[1]));
    }

    public static IPRange parseFromIPWithMask(String ipWithMask) {
        long minIpAsLong = 0L;
        long maxIpAsLong = 0L;
        String[] strs = ipWithMask.split("/");
        if (strs.length != 2) {
            throw new IllegalArgumentException("The input String format error. For example 192.168.1.1/24");
        }
        IP ip = IP.parseFromString(strs[0]);
        int mask = Integer.parseInt(strs[1]);
        long maskAsLong = -1 << 32 - mask;
        minIpAsLong = ip.toLong();
        maxIpAsLong = minIpAsLong | maskAsLong ^ 0xFFFFFFFFFFFFFFFFL;
        return new IPRange(new IP(minIpAsLong), new IP(maxIpAsLong));
    }

    public static IPRange AClassLocalIPRange() {
        return new IPRange(new IP(0xA000000L), new IP(0xAFFFFFFL));
    }

    public static IPRange BClassLocalIPRange() {
        return new IPRange(new IP(172, 16, 0, 0), new IP(172, 31, 255, 255));
    }

    public static IPRange CClassLocalIPRange() {
        return new IPRange(new IP(192, 168, 0, 0), new IP(192, 168, 255, 255));
    }

    public boolean contains(IP ip) {
        return ip.compareTo(this.startIP) >= 0 && ip.compareTo(this.endIP) <= 0;
    }

    public boolean contains(SocketAddress address) {
        return address instanceof InetSocketAddress && this.contains(((InetSocketAddress)address).getAddress());
    }

    public boolean contains(InetAddress address) {
        if (address instanceof Inet4Address) {
            IP ip = new IP(address.getAddress());
            return this.contains(ip);
        }
        return false;
    }

    public long size() {
        return this.endIP.getValue() - this.startIP.getValue() + 1L;
    }

    public IP getStartIP() {
        return this.startIP;
    }

    public IP getEndIP() {
        return this.endIP;
    }

    public List<IPRange> split(IP ip) {
        ArrayList<IPRange> ranges = new ArrayList<IPRange>();
        if (this.contains(ip)) {
            ranges.add(new IPRange(this.startIP, ip));
            ranges.add(new IPRange(ip, this.endIP));
        }
        return ranges;
    }

    @Override
    public Iterator<IP> iterator() {
        return new IPIterator(this.startIP, this.endIP);
    }

    public String toString() {
        return this.startIP + "-" + this.endIP;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPRange) {
            IPRange range = (IPRange)obj;
            return range.getStartIP().equals(this.startIP) && range.getEndIP().equals(this.endIP);
        }
        return false;
    }
}

