/*
 * Decompiled with CFR 0.152.
 */
package sockslib.common;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sockslib.common.IPRange;
import sockslib.utils.UnsignedByte;

public class IP
implements Comparable<IP>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long value;
    private final int a;
    private final int b;
    private final int c;
    private final int d;

    public IP(int a, int b, int c, int d) {
        Preconditions.checkArgument((this.checkRange(a) && this.checkRange(b) && this.checkRange(c) && this.checkRange(d) ? 1 : 0) != 0, (Object)"Each number of IP must in 0 ~ 255");
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.value = this.toLong();
    }

    public IP(long ip) {
        Preconditions.checkArgument((ip <= 0xFFFFFFFFL && ip >= 0L ? 1 : 0) != 0, (Object)"Invalid IP");
        this.value = ip;
        this.a = (int)(ip >>> 24);
        this.b = (int)((ip & 0xFFFFFFL) >>> 16);
        this.c = (int)((ip & 0xFFFFL) >>> 8);
        this.d = (int)(ip & 0xFFL);
    }

    public IP(byte[] address) {
        this.a = UnsignedByte.toInt(address[0]);
        this.b = UnsignedByte.toInt(address[1]);
        this.c = UnsignedByte.toInt(address[2]);
        this.d = UnsignedByte.toInt(address[3]);
        this.value = this.toLong();
    }

    public static IP parseFromString(String ip) {
        String regex = "\\s*(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\s*";
        Pattern pattern = Pattern.compile(regex);
        Matcher m = pattern.matcher(ip);
        Preconditions.checkArgument((boolean)m.find(), (String)"IP string should match the regex:%s", (Object[])new Object[]{regex});
        int a = Integer.parseInt(m.group(1));
        int b = Integer.parseInt(m.group(2));
        int c = Integer.parseInt(m.group(3));
        int d = Integer.parseInt(m.group(4));
        return new IP(a, b, c, d);
    }

    public static IP MAX_IP() {
        return new IP(0xFFFFFFFFL);
    }

    public static IP MIN_IP() {
        return new IP(0L);
    }

    public static boolean isValid(String ip) {
        try {
            IP.parseFromString(ip);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public int getC() {
        return this.c;
    }

    public int getD() {
        return this.d;
    }

    public IP nextIP() {
        return new IP(this.value + 1L);
    }

    public IP preIP() {
        return new IP(this.value - 1L);
    }

    public boolean isLocalIP() {
        return IPRange.AClassLocalIPRange().contains(this) || IPRange.BClassLocalIPRange().contains(this) || IPRange.CClassLocalIPRange().contains(this);
    }

    public boolean isUseInInternet() {
        return !this.isLocalIP();
    }

    public long toLong() {
        long a = this.a;
        long b = this.b;
        long c = this.c;
        long d = this.d;
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Override
    public int compareTo(IP ip) {
        return this.value > ip.getValue() ? 1 : (this.value < ip.getValue() ? -1 : 0);
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%s.%s.%s.%s", this.a, this.b, this.c, this.d);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IP) {
            IP ip = (IP)obj;
            if (this.getValue() == ip.getValue()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Hashing.md5().newHasher().putInt(this.a).putChar('.').putInt(this.b).putChar('.').putInt(this.c).putChar('.').putInt(this.d).hash().hashCode();
    }

    private boolean checkRange(int num) {
        return num >= 0 && num <= 255;
    }
}

