/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import sockslib.client.SSLSocks5;
import sockslib.client.Socks5;
import sockslib.client.SocksProxy;
import sockslib.common.KeyStoreInfo;
import sockslib.common.SSLConfiguration;
import sockslib.common.UsernamePasswordCredentials;
import sockslib.utils.PathUtil;

public class SocksProxyFactory {
    public static SocksProxy parse(String value) throws UnknownHostException, FileNotFoundException {
        SSLSocks5 socks = null;
        if (value == null) {
            throw new IllegalArgumentException("Input string can't be null");
        }
        String[] values = value.split(",");
        try {
            switch (values.length) {
                case 2: {
                    String host = values[0];
                    int port = Integer.parseInt(values[1]);
                    return new Socks5(host, port);
                }
                case 4: {
                    String host = values[0];
                    int port = Integer.parseInt(values[1]);
                    String username = values[2];
                    String password = values[3];
                    if (Strings.isNullOrEmpty((String)username)) {
                        return new Socks5(host, port);
                    }
                    return new Socks5(host, port, new UsernamePasswordCredentials(username, password));
                }
                case 6: {
                    String host = values[0];
                    int port = Integer.parseInt(values[1]);
                    String username = values[2];
                    String password = values[3];
                    KeyStoreInfo trustKeyStoreInfo = new KeyStoreInfo(PathUtil.getAbstractPath(values[4]), values[5]);
                    SSLConfiguration configuration = new SSLConfiguration(null, trustKeyStoreInfo);
                    socks = new SSLSocks5(new InetSocketAddress(host, port), configuration);
                    if (!Strings.isNullOrEmpty((String)username)) {
                        socks.setCredentials(new UsernamePasswordCredentials(username, password));
                    }
                    return socks;
                }
                case 8: {
                    String host = values[0];
                    int port = Integer.parseInt(values[1]);
                    String username = values[2];
                    String password = values[3];
                    KeyStoreInfo trustKeyStoreInfo = new KeyStoreInfo(PathUtil.getAbstractPath(values[4]), values[5]);
                    KeyStoreInfo keyStoreInfo = new KeyStoreInfo(PathUtil.getAbstractPath(values[6]), values[7]);
                    SSLConfiguration configuration = new SSLConfiguration(keyStoreInfo, trustKeyStoreInfo);
                    socks = new SSLSocks5(new InetSocketAddress(host, port), configuration);
                    if (!Strings.isNullOrEmpty((String)username)) {
                        socks.setCredentials(new UsernamePasswordCredentials(username, password));
                    }
                    return socks;
                }
            }
            throw new IllegalArgumentException("The input string should be formatted as [HOST],[IP],[USERNAME],[PASSWORD],[TRUST_KEY_STORE],[TRUST_KEY_STORE_PASSWORD],[KEY_STORE],[KEY_STORE_PASSWORD]");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Port should be a number between 1 and 65535");
        }
    }
}

