/*
 * Decompiled with CFR 0.152.
 */
package sockslib.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.List;
import sockslib.client.Socks5;
import sockslib.client.SocksProxy;
import sockslib.common.SSLConfiguration;
import sockslib.common.SSLConfigurationException;
import sockslib.common.SocksException;

public class SSLSocks5
extends Socks5 {
    private SSLConfiguration configuration;

    public SSLSocks5(SocketAddress address, SSLConfiguration configuration) {
        super(address);
        this.configuration = configuration;
    }

    public SSLSocks5(InetAddress address, int port, SSLConfiguration configuration) {
        super(address, port);
        this.configuration = configuration;
    }

    @Override
    public Socket createProxySocket(InetAddress address, int port) throws IOException {
        try {
            return this.configuration.getSSLSocketFactory().createSocket(address, port);
        }
        catch (SSLConfigurationException e) {
            throw new SocksException(e.getMessage());
        }
    }

    @Override
    public Socket createProxySocket() throws IOException {
        try {
            return this.configuration.getSSLSocketFactory().createSocket();
        }
        catch (SSLConfigurationException e) {
            throw new SocksException(e.getMessage());
        }
    }

    @Override
    public SocksProxy copy() {
        return this.copyWithoutChainProxy().setChainProxy(this.getChainProxy());
    }

    @Override
    public SocksProxy copyWithoutChainProxy() {
        SSLSocks5 socks5 = new SSLSocks5(this.getInetAddress(), this.getPort(), this.configuration);
        ((Socks5)socks5.setAcceptableMethods((List)this.getAcceptableMethods())).setAlwaysResolveAddressLocally(this.isAlwaysResolveAddressLocally()).setCredentials(this.getCredentials()).setInetAddress(this.getInetAddress()).setPort(this.getPort()).setSocksMethodRequester(this.getSocksMethodRequester());
        return socks5;
    }

    public SSLConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SSLConfiguration configuration) {
        this.configuration = configuration;
    }
}

