/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import jnr.ffi.CallingConvention;
import jnr.ffi.LibraryOption;
import jnr.ffi.mapper.CompositeFunctionMapper;
import jnr.ffi.mapper.CompositeTypeMapper;
import jnr.ffi.mapper.FunctionMapper;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.mapper.SignatureTypeMapperAdapter;
import jnr.ffi.mapper.TypeMapper;
import jnr.ffi.provider.FFIProvider;
import jnr.ffi.provider.LoadedLibrary;

public abstract class LibraryLoader<T> {
    private final List<String> searchPaths = new ArrayList<String>();
    private final List<String> libraryNames = new ArrayList<String>();
    private final List<SignatureTypeMapper> typeMappers = new ArrayList<SignatureTypeMapper>();
    private final List<FunctionMapper> functionMappers = new ArrayList<FunctionMapper>();
    private final Map<LibraryOption, Object> optionMap = new EnumMap<LibraryOption, Object>(LibraryOption.class);
    private final Class<T> interfaceClass;
    private boolean failImmediately = false;

    public static <T> LibraryLoader<T> create(Class<T> interfaceClass) {
        return FFIProvider.getSystemProvider().createLibraryLoader(interfaceClass);
    }

    protected LibraryLoader(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public LibraryLoader<T> library(String libraryName) {
        this.libraryNames.add(libraryName);
        return this;
    }

    public LibraryLoader<T> search(String path) {
        this.searchPaths.add(path);
        return this;
    }

    public LibraryLoader<T> option(LibraryOption option, Object value) {
        switch (option) {
            case TypeMapper: {
                if (value instanceof SignatureTypeMapper) {
                    this.mapper((SignatureTypeMapper)value);
                    break;
                }
                if (value instanceof TypeMapper) {
                    this.mapper((TypeMapper)value);
                    break;
                }
                if (value == null) break;
                throw new IllegalArgumentException("invalid TypeMapper: " + value.getClass());
            }
            case FunctionMapper: {
                this.mapper((FunctionMapper)value);
                break;
            }
            default: {
                this.optionMap.put(option, value);
            }
        }
        return this;
    }

    public LibraryLoader<T> mapper(TypeMapper typeMapper) {
        this.typeMappers.add(new SignatureTypeMapperAdapter(typeMapper));
        return this;
    }

    public LibraryLoader<T> mapper(SignatureTypeMapper typeMapper) {
        this.typeMappers.add(typeMapper);
        return this;
    }

    public LibraryLoader<T> mapper(FunctionMapper typeMapper) {
        this.optionMap.put(LibraryOption.FunctionMapper, typeMapper);
        return this;
    }

    public LibraryLoader<T> convention(CallingConvention convention) {
        this.optionMap.put(LibraryOption.CallingConvention, (Object)convention);
        return this;
    }

    public final LibraryLoader<T> stdcall() {
        return this.convention(CallingConvention.STDCALL);
    }

    public final LibraryLoader<T> failImmediately() {
        this.failImmediately = true;
        return this;
    }

    public T load(String libraryName) {
        return this.library(libraryName).load();
    }

    public T load() {
        if (this.libraryNames.isEmpty()) {
            throw new UnsatisfiedLinkError("no library names specified");
        }
        if (!this.typeMappers.isEmpty()) {
            SignatureTypeMapper typeMapper = this.typeMappers.size() > 1 ? new CompositeTypeMapper(this.typeMappers) : this.typeMappers.get(0);
            this.optionMap.put(LibraryOption.TypeMapper, typeMapper);
        }
        if (!this.functionMappers.isEmpty()) {
            FunctionMapper functionMapper = this.functionMappers.size() > 1 ? new CompositeFunctionMapper(this.functionMappers) : this.functionMappers.get(0);
            this.optionMap.put(LibraryOption.FunctionMapper, functionMapper);
        }
        try {
            return this.loadLibrary(this.interfaceClass, Collections.unmodifiableList(this.libraryNames), this.getSearchPaths(), Collections.unmodifiableMap(this.optionMap));
        }
        catch (LinkageError error) {
            if (this.failImmediately) {
                throw error;
            }
            return this.createErrorProxy(error);
        }
        catch (Exception ex) {
            RuntimeException re;
            RuntimeException runtimeException = re = ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException(ex);
            if (this.failImmediately) {
                throw re;
            }
            return this.createErrorProxy(re);
        }
    }

    private T createErrorProxy(final Throwable ex) {
        return this.interfaceClass.cast(Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass, LoadedLibrary.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw ex;
            }
        }));
    }

    private Collection<String> getSearchPaths() {
        ArrayList<String> paths = new ArrayList<String>(this.searchPaths);
        paths.addAll(StaticDataHolder.USER_LIBRARY_PATH);
        return Collections.unmodifiableList(paths);
    }

    protected abstract T loadLibrary(Class<T> var1, Collection<String> var2, Collection<String> var3, Map<LibraryOption, Object> var4);

    private static List<String> getPropertyPaths(String propName) {
        String value = System.getProperty(propName);
        if (value != null) {
            String[] paths = value.split(File.pathSeparator);
            return new ArrayList<String>(Arrays.asList(paths));
        }
        return Collections.emptyList();
    }

    private static final class StaticDataHolder {
        private static final List<String> USER_LIBRARY_PATH;

        private StaticDataHolder() {
        }

        static {
            ArrayList paths = new ArrayList();
            try {
                paths.addAll(LibraryLoader.getPropertyPaths("jnr.ffi.library.path"));
                paths.addAll(LibraryLoader.getPropertyPaths("jaffl.library.path"));
                paths.addAll(LibraryLoader.getPropertyPaths("jna.library.path"));
                paths.addAll(LibraryLoader.getPropertyPaths("java.library.path"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            USER_LIBRARY_PATH = Collections.unmodifiableList(new ArrayList(paths));
        }
    }
}

